/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.util;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import bending.libraries.jackson.databind.ObjectMapper;
import bending.libraries.jackson.databind.json.JsonMapper;
import bending.libraries.jackson.dataformat.toml.TomlMapper;

public class ObjectMapperFactory {
    public static ObjectMapper getObjectMapper(String file) {
        String extension = ObjectMapperFactory.getFileExtension(file);
        return switch (extension.toLowerCase()) {
            case ".json" -> new JsonMapper();
            case ".toml" -> new TomlMapper();
            default -> throw new FlywayException("No mapper found for '" + extension + "' extension");
        };
    }

    private static String getFileExtension(String filename) {
        int dotLocation;
        if (StringUtils.hasText(filename) && (dotLocation = filename.lastIndexOf(46)) > 0) {
            return filename.substring(dotLocation);
        }
        return "";
    }
}

