/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.bnf.context;

import bending.libraries.h2.bnf.Bnf;
import bending.libraries.h2.bnf.BnfVisitor;
import bending.libraries.h2.bnf.Rule;
import bending.libraries.h2.bnf.RuleElement;
import bending.libraries.h2.bnf.RuleHead;
import bending.libraries.h2.bnf.RuleList;
import bending.libraries.h2.bnf.Sentence;
import bending.libraries.h2.bnf.context.DbColumn;
import bending.libraries.h2.bnf.context.DbContents;
import bending.libraries.h2.bnf.context.DbProcedure;
import bending.libraries.h2.bnf.context.DbSchema;
import bending.libraries.h2.bnf.context.DbTableOrView;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.util.ParserUtil;
import bending.libraries.h2.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;

public class DbContextRule
implements Rule {
    public static final int COLUMN = 0;
    public static final int TABLE = 1;
    public static final int TABLE_ALIAS = 2;
    public static final int NEW_TABLE_ALIAS = 3;
    public static final int COLUMN_ALIAS = 4;
    public static final int SCHEMA = 5;
    public static final int PROCEDURE = 6;
    private final DbContents contents;
    private final int type;
    private String columnType;

    public DbContextRule(DbContents dbContents, int n) {
        this.contents = dbContents;
        this.type = n;
    }

    public void setColumnType(String string) {
        this.columnType = string;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
    }

    @Override
    public void accept(BnfVisitor bnfVisitor) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean autoComplete(Sentence sentence) {
        String string;
        String string2 = string = sentence.getQuery();
        switch (this.type) {
            case 5: {
                DbSchema[] dbSchemaArray = this.contents.getSchemas();
                String object2 = null;
                DbSchema dbSchema = null;
                for (DbSchema dbSchema2 : dbSchemaArray) {
                    String string3 = dbSchema2.name;
                    String string4 = StringUtils.quoteIdentifier(string3);
                    if (StringUtils.startsWithIgnoringCase(string, string3)) {
                        if (object2 != null && string3.length() <= object2.length()) continue;
                        object2 = string3;
                        dbSchema = dbSchema2;
                        continue;
                    }
                    if (StringUtils.startsWith(string, string4)) {
                        if (object2 != null && string3.length() <= object2.length()) continue;
                        object2 = string4;
                        dbSchema = dbSchema2;
                        continue;
                    }
                    if (!string2.isEmpty() && !StringUtils.startsWithIgnoringCase(string3, string) && !StringUtils.startsWithIgnoringCase(string4, string) || string2.length() >= string3.length()) continue;
                    sentence.add(string3, string3.substring(string2.length()), this.type);
                    sentence.add(dbSchema2.quotedName + ".", dbSchema2.quotedName.substring(string2.length()) + ".", 0);
                }
                if (object2 == null) break;
                sentence.setLastMatchedSchema(dbSchema);
                string2 = string2.substring(object2.length());
                break;
            }
            case 1: {
                void object;
                DbSchema dbSchema = sentence.getLastMatchedSchema();
                if (dbSchema == null) {
                    dbSchema = this.contents.getDefaultSchema();
                }
                DbTableOrView[] dbTableOrViewArray = dbSchema.getTables();
                String string4 = null;
                Object object3 = null;
                DbTableOrView[] dbTableOrViewArray2 = dbTableOrViewArray;
                int n = dbTableOrViewArray2.length;
                boolean bl = false;
                while (object < n) {
                    DbTableOrView dbTableOrView = dbTableOrViewArray2[object];
                    String string5 = dbTableOrView.getName();
                    String string6 = StringUtils.quoteIdentifier(string5);
                    if (StringUtils.startsWithIgnoringCase(string, string5) || StringUtils.startsWithIgnoringCase("\"" + string, string6)) {
                        if (string4 == null || string5.length() > string4.length()) {
                            string4 = string5;
                            object3 = dbTableOrView;
                        }
                    } else if ((string2.isEmpty() || StringUtils.startsWithIgnoringCase(string5, string) || StringUtils.startsWithIgnoringCase(string6, string)) && string2.length() < string5.length()) {
                        sentence.add(dbTableOrView.getQuotedName(), dbTableOrView.getQuotedName().substring(string2.length()), 0);
                    }
                    ++object;
                }
                if (string4 == null) break;
                sentence.setLastMatchedTable((DbTableOrView)object3);
                sentence.addTable((DbTableOrView)object3);
                string2 = string2.substring(string4.length());
                break;
            }
            case 3: {
                string2 = DbContextRule.autoCompleteTableAlias(sentence, true);
                break;
            }
            case 2: {
                string2 = DbContextRule.autoCompleteTableAlias(sentence, false);
                break;
            }
            case 4: {
                int n = 0;
                if (string.indexOf(32) < 0) break;
                int n2 = string.length();
                int n3 = string.codePointAt(n);
                if (!Character.isJavaIdentifierStart(n3) || n3 == 36) break;
                while ((n += Character.charCount(n3)) < n2 && Character.isJavaIdentifierPart(n3 = string.codePointAt(n))) {
                }
                Object object3 = string.substring(0, n);
                if (ParserUtil.isKeyword((String)object3, false)) break;
                string2 = string2.substring(((String)object3).length());
                break;
            }
            case 0: {
                HashSet<DbTableOrView> hashSet = sentence.getTables();
                String string7 = null;
                DbTableOrView dbTableOrView = sentence.getLastMatchedTable();
                if (dbTableOrView != null && dbTableOrView.getColumns() != null) {
                    for (DbColumn dbColumn : dbTableOrView.getColumns()) {
                        void var11_29;
                        String string8 = string;
                        String string9 = dbColumn.getName();
                        if (dbColumn.getQuotedName().length() > string9.length()) {
                            string9 = dbColumn.getQuotedName();
                            String string10 = string;
                        }
                        if (!StringUtils.startsWithIgnoringCase((String)var11_29, string9) || !this.testColumnType(dbColumn)) continue;
                        String string11 = string2.substring(string9.length());
                        if (string7 == null || string11.length() < string7.length()) {
                            string7 = string11;
                            continue;
                        }
                        if (!string2.isEmpty() && !StringUtils.startsWithIgnoringCase(string9, (String)var11_29) || string2.length() >= string9.length()) continue;
                        sentence.add(dbColumn.getName(), dbColumn.getName().substring(string2.length()), 0);
                    }
                }
                for (DbSchema dbSchema : this.contents.getSchemas()) {
                    for (DbTableOrView dbTableOrView2 : dbSchema.getTables()) {
                        if (dbTableOrView2 != dbTableOrView && hashSet != null && !hashSet.contains(dbTableOrView2) || dbTableOrView2 == null || dbTableOrView2.getColumns() == null) continue;
                        for (DbColumn dbColumn : dbTableOrView2.getColumns()) {
                            String string12 = dbColumn.getName();
                            if (!this.testColumnType(dbColumn)) continue;
                            if (StringUtils.startsWithIgnoringCase(string, string12)) {
                                String string13 = string2.substring(string12.length());
                                if (string7 != null && string13.length() >= string7.length()) continue;
                                string7 = string13;
                                continue;
                            }
                            if (!string2.isEmpty() && !StringUtils.startsWithIgnoringCase(string12, string) || string2.length() >= string12.length()) continue;
                            sentence.add(dbColumn.getName(), dbColumn.getName().substring(string2.length()), 0);
                        }
                    }
                }
                if (string7 == null) break;
                string2 = string7;
                break;
            }
            case 6: {
                this.autoCompleteProcedure(sentence);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        if (!string2.equals(string)) {
            while (Bnf.startWithSpace(string2)) {
                string2 = string2.substring(1);
            }
            sentence.setQuery(string2);
            return true;
        }
        return false;
    }

    private boolean testColumnType(DbColumn dbColumn) {
        if (this.columnType == null) {
            return true;
        }
        String string = dbColumn.getDataType();
        if (this.columnType.contains("CHAR") || this.columnType.contains("CLOB")) {
            return string.contains("CHAR") || string.contains("CLOB");
        }
        if (this.columnType.contains("BINARY") || this.columnType.contains("BLOB")) {
            return string.contains("BINARY") || string.contains("BLOB");
        }
        return string.contains(this.columnType);
    }

    private void autoCompleteProcedure(Sentence sentence) {
        String string;
        DbSchema dbSchema = sentence.getLastMatchedSchema();
        if (dbSchema == null) {
            dbSchema = this.contents.getDefaultSchema();
        }
        String string2 = string = sentence.getQueryUpper();
        int n = string.indexOf(40);
        if (n != -1) {
            string2 = StringUtils.trimSubstring(string, 0, n);
        }
        RuleElement ruleElement = new RuleElement("(", "Function");
        RuleElement ruleElement2 = new RuleElement(")", "Function");
        RuleElement ruleElement3 = new RuleElement(",", "Function");
        for (DbProcedure dbProcedure : dbSchema.getProcedures()) {
            String string3 = dbProcedure.getName();
            if (!string3.startsWith(string2)) continue;
            RuleElement ruleElement4 = new RuleElement(string3, "Function");
            RuleList ruleList = new RuleList(ruleElement4, ruleElement, false);
            if (string.contains("(")) {
                for (DbColumn dbColumn : dbProcedure.getParameters()) {
                    if (dbColumn.getPosition() > 1) {
                        ruleList = new RuleList(ruleList, ruleElement3, false);
                    }
                    DbContextRule dbContextRule = new DbContextRule(this.contents, 0);
                    String string4 = dbColumn.getDataType();
                    if (string4.contains("(")) {
                        string4 = string4.substring(0, string4.indexOf(40));
                    }
                    dbContextRule.setColumnType(string4);
                    ruleList = new RuleList(ruleList, dbContextRule, false);
                }
                ruleList = new RuleList(ruleList, ruleElement2, false);
            }
            ruleList.autoComplete(sentence);
        }
    }

    private static String autoCompleteTableAlias(Sentence sentence, boolean bl) {
        HashMap<String, DbTableOrView> hashMap;
        char c;
        int n;
        String string = sentence.getQuery();
        String string2 = sentence.getQueryUpper();
        for (n = 0; n < string2.length() && ((c = string2.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == 0) {
            return string;
        }
        String string3 = string2.substring(0, n);
        if ("SET".equals(string3) || ParserUtil.isKeyword(string3, false)) {
            return string;
        }
        if (bl) {
            sentence.addAlias(string3, sentence.getLastTable());
        }
        if ((hashMap = sentence.getAliases()) != null && hashMap.containsKey(string3) || sentence.getLastTable() == null) {
            if (bl && string.length() == string3.length()) {
                return string;
            }
            if ((string = string.substring(string3.length())).isEmpty()) {
                sentence.add(string3 + ".", ".", 0);
            }
            return string;
        }
        HashSet<DbTableOrView> hashSet = sentence.getTables();
        if (hashSet != null) {
            String string4 = null;
            for (DbTableOrView dbTableOrView : hashSet) {
                String string5 = StringUtils.toUpperEnglish(dbTableOrView.getName());
                if (string3.startsWith(string5) && (string4 == null || string5.length() > string4.length())) {
                    sentence.setLastMatchedTable(dbTableOrView);
                    string4 = string5;
                    continue;
                }
                if (!string.isEmpty() && !string5.startsWith(string3)) continue;
                sentence.add(string5 + ".", string5.substring(string.length()) + ".", 0);
            }
            if (string4 != null) {
                if ((string = string.substring(string4.length())).isEmpty()) {
                    sentence.add(string3 + ".", ".", 0);
                }
                return string;
            }
        }
        return string;
    }
}

