/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.command;

import bending.libraries.h2.command.CommandInterface;
import bending.libraries.h2.engine.Database;
import bending.libraries.h2.engine.DbObject;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.expression.ParameterInterface;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.message.Trace;
import bending.libraries.h2.result.BatchResult;
import bending.libraries.h2.result.MergedResult;
import bending.libraries.h2.result.ResultInterface;
import bending.libraries.h2.result.ResultWithGeneratedKeys;
import bending.libraries.h2.table.Table;
import bending.libraries.h2.util.Utils;
import bending.libraries.h2.value.Value;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;

public abstract class Command
implements CommandInterface {
    protected final SessionLocal session;
    protected long startTimeNanos;
    private final Trace trace;
    private volatile boolean cancel;
    private final String sql;
    private boolean canReuse;

    Command(SessionLocal sessionLocal, String string) {
        this.session = sessionLocal;
        this.sql = string;
        this.trace = this.getDatabase().getTrace(0);
    }

    public abstract boolean isTransactional();

    @Override
    public abstract boolean isQuery();

    @Override
    public abstract ArrayList<? extends ParameterInterface> getParameters();

    public abstract boolean isReadOnly();

    public abstract ResultInterface queryMeta();

    public abstract ResultWithGeneratedKeys update(Object var1);

    public abstract ResultInterface query(long var1);

    @Override
    public final ResultInterface getMetaData() {
        return this.queryMeta();
    }

    void start() {
        if (this.trace.isInfoEnabled() || this.getDatabase().getQueryStatistics()) {
            this.startTimeNanos = Utils.currentNanoTime();
        }
    }

    void setProgress(Database database, int n) {
        database.setProgress(n, this.sql, 0L, 0L);
    }

    protected void checkCanceled() {
        if (this.cancel) {
            this.cancel = false;
            throw DbException.get(57014);
        }
    }

    @Override
    public void stop(boolean bl) {
        long l;
        if (this.session.isOpen()) {
            this.commitIfNonTransactional();
            if (bl && this.isTransactional() && this.session.getAutoCommit()) {
                this.session.commit(false);
            }
        }
        if (this.trace.isInfoEnabled() && this.startTimeNanos != 0L && (l = (System.nanoTime() - this.startTimeNanos) / 1000000L) > 100L) {
            this.trace.info("slow query: {0} ms", l);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultInterface executeQuery(long var1_1, int var3_2, boolean var4_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultWithGeneratedKeys executeUpdate(Object object) {
        this.session.lock();
        try {
            this.session.waitIfExclusiveModeEnabled();
            ResultWithGeneratedKeys resultWithGeneratedKeys = this.executeUpdate(object, true);
            return resultWithGeneratedKeys;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchResult executeBatchUpdate(ArrayList<Value[]> arrayList, Object object) {
        this.session.lock();
        try {
            this.session.waitIfExclusiveModeEnabled();
            int n = arrayList.size();
            long[] lArray = new long[n];
            MergedResult mergedResult = object != null ? new MergedResult() : null;
            ArrayList<SQLException> arrayList2 = new ArrayList<SQLException>();
            for (int i = 0; i < n; ++i) {
                long l;
                Value[] valueArray = arrayList.get(i);
                ArrayList<? extends ParameterInterface> arrayList3 = this.getParameters();
                int n2 = valueArray.length;
                for (int j = 0; j < n2; ++j) {
                    arrayList3.get(j).setValue(valueArray[j], true);
                }
                try {
                    ResultInterface resultInterface;
                    ResultWithGeneratedKeys resultWithGeneratedKeys = this.executeUpdate(object, i + 1 == n);
                    l = resultWithGeneratedKeys.getUpdateCount();
                    if (mergedResult != null && (resultInterface = resultWithGeneratedKeys.getGeneratedKeys()) != null) {
                        mergedResult.add(resultInterface);
                    }
                }
                catch (Exception exception) {
                    arrayList2.add(DbException.toSQLException(exception));
                    l = -3L;
                }
                lArray[i] = l;
            }
            BatchResult batchResult = new BatchResult(lArray, mergedResult != null ? mergedResult.getResult() : null, arrayList2);
            return batchResult;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private ResultWithGeneratedKeys executeUpdate(Object var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void commitIfNonTransactional() {
        if (!this.isTransactional()) {
            boolean bl = this.session.getAutoCommit();
            this.session.commit(true);
            if (!bl && this.session.getAutoCommit()) {
                this.session.begin();
            }
        }
    }

    private long filterConcurrentUpdate(DbException dbException, long l) {
        int n = dbException.getErrorCode();
        if (n != 90131 && n != 90143 && n != 90112) {
            throw dbException;
        }
        long l2 = Utils.currentNanoTime();
        if (l != 0L && l2 - l > (long)this.session.getLockTimeout() * 1000000L) {
            throw DbException.get(50200, dbException, new String[0]);
        }
        return l == 0L ? l2 : l;
    }

    @Override
    public void close() {
        this.canReuse = true;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean canReuse() {
        return this.canReuse;
    }

    public void reuse() {
        this.canReuse = false;
        ArrayList<? extends ParameterInterface> arrayList = this.getParameters();
        for (ParameterInterface parameterInterface : arrayList) {
            parameterInterface.setValue(null, true);
        }
    }

    public abstract Set<DbObject> getDependencies();

    public abstract void invalidateCachedResult(Table var1);

    protected abstract boolean isRetryable();

    protected final Database getDatabase() {
        return this.session.getDatabase();
    }
}

