/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.command.ddl;

import bending.libraries.h2.command.ddl.AlterDomain;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.schema.Domain;
import bending.libraries.h2.schema.Schema;
import bending.libraries.h2.table.Column;
import bending.libraries.h2.value.ExtTypeInfoEnum;
import bending.libraries.h2.value.TypeInfo;

public class AlterType
extends AlterDomain {
    private String value;

    public AlterType(SessionLocal sessionLocal, Schema schema) {
        super(sessionLocal, schema);
    }

    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public long update(Schema schema, Domain domain) {
        TypeInfo typeInfo = domain.getDataType();
        if (typeInfo.getValueType() != 36) {
            throw DbException.get(42809, this.domainName);
        }
        ExtTypeInfoEnum extTypeInfoEnum = (ExtTypeInfoEnum)typeInfo.getExtTypeInfo();
        int n = extTypeInfoEnum.getCount();
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = extTypeInfoEnum.getEnumerator(i);
        }
        stringArray[n] = this.value;
        domain.setDataType(TypeInfo.getTypeInfo(36, -1L, -1, new ExtTypeInfoEnum(stringArray)));
        schema.getDatabase().updateMeta(this.session, domain);
        AlterType.forAllDependencies(this.session, domain, this::copyDomain, null, false);
        return 0L;
    }

    private boolean copyDomain(Domain domain, Column column) {
        column.setType(domain.getDataType());
        return true;
    }

    @Override
    public int getType() {
        return 105;
    }
}

