/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.command.ddl;

import bending.libraries.h2.command.ddl.SchemaCommand;
import bending.libraries.h2.constraint.Constraint;
import bending.libraries.h2.engine.Database;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.index.Index;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.schema.Schema;
import bending.libraries.h2.table.Table;

public class DropIndex
extends SchemaCommand {
    private String indexName;
    private boolean ifExists;

    public DropIndex(SessionLocal sessionLocal, Schema schema) {
        super(sessionLocal, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    @Override
    public long update() {
        Database database = this.getDatabase();
        Index index = this.getSchema().findIndex(this.session, this.indexName);
        if (index == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.indexName);
            }
        } else {
            Table table = index.getTable();
            this.session.getUser().checkTableRight(index.getTable(), 32);
            Constraint constraint = null;
            Iterable<Constraint> iterable = table.getConstraints();
            for (Constraint constraint2 : table.getConstraints()) {
                if (!constraint2.usesIndex(index)) continue;
                if (Constraint.Type.PRIMARY_KEY == constraint2.getConstraintType()) {
                    for (Constraint constraint3 : iterable) {
                        if (constraint3.getReferencedConstraint() != constraint2) continue;
                        throw DbException.get(90085, this.indexName, constraint2.getName());
                    }
                    constraint = constraint2;
                    continue;
                }
                throw DbException.get(90085, this.indexName, constraint2.getName());
            }
            index.getTable().setModified();
            if (constraint != null) {
                database.removeSchemaObject(this.session, constraint);
            } else {
                database.removeSchemaObject(this.session, index);
            }
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 40;
    }
}

