/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.command.dml;

import bending.libraries.h2.command.Prepared;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.expression.Expression;
import bending.libraries.h2.result.ResultInterface;
import bending.libraries.h2.result.ResultTarget;
import bending.libraries.h2.result.Row;
import bending.libraries.h2.table.DataChangeDeltaTable;
import bending.libraries.h2.table.Table;
import bending.libraries.h2.table.TableFilter;

public abstract class DataChangeStatement
extends Prepared {
    private boolean isPrepared;

    protected DataChangeStatement(SessionLocal sessionLocal) {
        super(sessionLocal);
    }

    @Override
    public final void prepare() {
        if (this.isPrepared) {
            return;
        }
        this.doPrepare();
        this.isPrepared = true;
    }

    abstract void doPrepare();

    public abstract String getStatementName();

    public abstract Table getTable();

    @Override
    public final boolean isTransactional() {
        return true;
    }

    @Override
    public final ResultInterface queryMeta() {
        return null;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public final long update() {
        return this.update(null, null);
    }

    public abstract long update(ResultTarget var1, DataChangeDeltaTable.ResultOption var2);

    protected final Row lockAndRecheckCondition(TableFilter tableFilter, Expression expression) {
        Table table = tableFilter.getTable();
        Row row = tableFilter.get();
        if (table.isRowLockable()) {
            Row row2 = table.lockRow(this.session, row, -1);
            if (row2 == null) {
                return null;
            }
            if (!row.hasSharedData(row2)) {
                row = row2;
                tableFilter.set(row);
                if (expression != null && !expression.getBooleanValue(this.session)) {
                    return null;
                }
            }
        }
        return row;
    }
}

