/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.expression;

import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.expression.Expression;
import bending.libraries.h2.expression.ExpressionVisitor;
import bending.libraries.h2.expression.ExpressionWithVariableParameters;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.table.ColumnResolver;
import bending.libraries.h2.table.TableFilter;
import bending.libraries.h2.value.TypeInfo;
import java.util.Arrays;
import java.util.function.Predicate;

public abstract class OperationN
extends Expression
implements ExpressionWithVariableParameters {
    protected Expression[] args;
    protected int argsCount;
    protected TypeInfo type;

    protected OperationN(Expression[] expressionArray) {
        this.args = expressionArray;
    }

    @Override
    public void addParameter(Expression expression) {
        int n = this.args.length;
        if (this.argsCount >= n) {
            this.args = Arrays.copyOf(this.args, n * 2);
        }
        this.args[this.argsCount++] = expression;
    }

    @Override
    public void doneWithParameters() throws DbException {
        if (this.args.length != this.argsCount) {
            this.args = Arrays.copyOf(this.args, this.argsCount);
        }
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.args) {
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    protected boolean optimizeArguments(SessionLocal sessionLocal, boolean bl) {
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            Expression expression;
            this.args[i] = expression = this.args[i].optimize(sessionLocal);
            if (!bl || expression.isConstant()) continue;
            bl = false;
        }
        return bl;
    }

    protected final void inlineSubexpressions(Predicate<Expression> predicate) {
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            Expression expression = this.args[i];
            if (!predicate.test(expression)) continue;
            this.inlineSubexpressions(predicate, i, n, expression);
            break;
        }
    }

    private void inlineSubexpressions(Predicate<Expression> predicate, int n, int n2, Expression expression) {
        int n3 = expression.getSubexpressionCount();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = n2;
        if (n3 != 1) {
            bl2 = true;
            n4 += n3 - 1;
        }
        for (int i = n + 1; i < n2; ++i) {
            Expression expression2 = this.args[i];
            if (!predicate.test(expression2)) continue;
            bl = true;
            int n5 = expression2.getSubexpressionCount();
            if (n5 == 1) continue;
            bl2 = true;
            n4 += n5 - 1;
        }
        Expression[] expressionArray = this.args;
        if (bl2) {
            this.args = new Expression[n4];
            System.arraycopy(expressionArray, 0, this.args, 0, n);
        }
        this.copyArgs(expression, n, n3);
        if (bl) {
            int n6 = n + n3;
            while (++n < n2) {
                Expression expression3 = expressionArray[n];
                if (predicate.test(expression3)) {
                    int n7 = expression3.getSubexpressionCount();
                    this.copyArgs(expression3, n6, n7);
                    n6 += n7;
                    continue;
                }
                this.args[n6++] = expression3;
            }
        } else if (bl2) {
            System.arraycopy(expressionArray, n + 1, this.args, n + n3, n2 - n - 1);
        }
    }

    private void copyArgs(Expression expression, int n, int n2) {
        if (expression instanceof OperationN) {
            System.arraycopy(((OperationN)expression).args, 0, this.args, n, n2);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.args[n + i] = expression.getSubexpression(i);
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public void updateAggregate(SessionLocal sessionLocal, int n) {
        for (Expression expression : this.args) {
            expression.updateAggregate(sessionLocal, n);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = this.args.length + 1;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int n) {
        return this.args[n];
    }
}

