/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.expression.aggregate;

import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.expression.aggregate.AggregateData;
import bending.libraries.h2.expression.function.GCDFunction;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.value.Value;
import bending.libraries.h2.value.ValueNull;
import bending.libraries.h2.value.ValueNumeric;
import java.math.BigInteger;

final class AggregateDataGCD
extends AggregateData {
    private final boolean lcm;
    private boolean skipRemaining;
    private boolean overflow;
    private BigInteger bi;

    AggregateDataGCD(boolean bl) {
        this.lcm = bl;
    }

    @Override
    void add(SessionLocal sessionLocal, Value value) {
        if (value == ValueNull.INSTANCE || this.skipRemaining) {
            return;
        }
        BigInteger bigInteger = value.getBigInteger();
        if (this.lcm) {
            if (bigInteger.signum() == 0) {
                this.bi = BigInteger.ZERO;
                this.skipRemaining = true;
                this.overflow = false;
            } else if (this.bi == null) {
                this.bi = bigInteger.abs();
            } else if (!this.overflow) {
                this.bi = this.bi.multiply(bigInteger).abs().divide(this.bi.gcd(bigInteger));
                this.overflow = this.bi.bitLength() > GCDFunction.MAX_BIT_LENGTH;
            }
        } else {
            if (this.bi == null) {
                this.bi = bigInteger.abs();
            } else if (bigInteger.signum() != 0) {
                this.bi = this.bi.gcd(bigInteger);
            } else {
                return;
            }
            this.skipRemaining = this.bi.equals(BigInteger.ONE);
        }
    }

    @Override
    Value getValue(SessionLocal sessionLocal) {
        if (this.overflow) {
            throw DbException.getValueTooLongException("NUMERIC", "unknown least common multiple", -1L);
        }
        return this.bi != null ? ValueNumeric.get(this.bi) : ValueNull.INSTANCE;
    }
}

