/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.expression.condition;

import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.expression.Expression;
import bending.libraries.h2.expression.ExpressionColumn;
import bending.libraries.h2.expression.ExpressionList;
import bending.libraries.h2.expression.ExpressionVisitor;
import bending.libraries.h2.expression.condition.Condition;
import bending.libraries.h2.index.IndexCondition;
import bending.libraries.h2.table.Column;
import bending.libraries.h2.table.TableFilter;
import bending.libraries.h2.value.TypeInfo;
import bending.libraries.h2.value.Value;
import java.util.ArrayList;

abstract class ConditionIn
extends Condition {
    Expression left;
    final boolean not;
    final boolean whenOperand;
    final ArrayList<Expression> valueList;

    ConditionIn(Expression expression, boolean bl, boolean bl2, ArrayList<Expression> arrayList) {
        this.left = expression;
        this.not = bl;
        this.whenOperand = bl2;
        this.valueList = arrayList;
    }

    @Override
    public final Value getValue(SessionLocal sessionLocal) {
        return this.getValue(sessionLocal, this.left.getValue(sessionLocal));
    }

    @Override
    public final boolean getWhenValue(SessionLocal sessionLocal, Value value) {
        if (!this.whenOperand) {
            return super.getWhenValue(sessionLocal, value);
        }
        return this.getValue(sessionLocal, value).isTrue();
    }

    abstract Value getValue(SessionLocal var1, Value var2);

    @Override
    public final boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public final void createIndexConditions(SessionLocal sessionLocal, TableFilter tableFilter) {
        ExpressionList expressionList;
        if (this.not || this.whenOperand || !sessionLocal.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (this.left instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
            if (tableFilter == expressionColumn.getTableFilter()) {
                this.createIndexConditions(tableFilter, expressionColumn, this.valueList);
            }
        } else if (this.left instanceof ExpressionList && !(expressionList = (ExpressionList)this.left).isArray()) {
            this.createCompoundIndexCondition(tableFilter, expressionList);
            this.createUniqueIndexConditions(tableFilter, expressionList);
        }
    }

    private void createCompoundIndexCondition(TableFilter tableFilter, ExpressionList expressionList) {
        Object object;
        int n = expressionList.getSubexpressionCount();
        Column[] columnArray = new Column[n];
        for (int i = 0; i < n; ++i) {
            object = expressionList.getSubexpression(i);
            if (!(object instanceof ExpressionColumn)) {
                return;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)object;
            if (tableFilter != expressionColumn.getTableFilter()) {
                return;
            }
            columnArray[i] = expressionColumn.getColumn();
        }
        TypeInfo typeInfo = this.left.getType();
        object = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
        for (Expression expression : this.valueList) {
            if (expression.isEverything((ExpressionVisitor)object) && TypeInfo.haveSameOrdering(typeInfo, TypeInfo.getHigherType(typeInfo, expression.getType()))) continue;
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getCompoundInList(columnArray, this.valueList));
    }

    abstract void createUniqueIndexConditions(TableFilter var1, ExpressionList var2);

    abstract void createIndexConditions(TableFilter var1, ExpressionColumn var2, ArrayList<Expression> var3);

    @Override
    public final boolean needParentheses() {
        return true;
    }

    @Override
    public final StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        return this.getWhenSQL(this.left.getSQL(stringBuilder, n, 0), n);
    }

    @Override
    public final StringBuilder getWhenSQL(StringBuilder stringBuilder, int n) {
        if (this.not) {
            stringBuilder.append(" NOT");
        }
        return ConditionIn.writeExpressions(stringBuilder.append(" IN("), this.valueList, n).append(')');
    }

    @Override
    public final int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public final Expression getSubexpression(int n) {
        if (n == 0) {
            return this.left;
        }
        if (n > 0 && n <= this.valueList.size()) {
            return this.valueList.get(n - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

