/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.expression.function;

import bending.libraries.h2.command.Parser;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.expression.Expression;
import bending.libraries.h2.expression.ExpressionVisitor;
import bending.libraries.h2.expression.function.Function1_2;
import bending.libraries.h2.index.Index;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.mvstore.db.MVSpatialIndex;
import bending.libraries.h2.table.Column;
import bending.libraries.h2.table.Table;
import bending.libraries.h2.value.TypeInfo;
import bending.libraries.h2.value.Value;
import bending.libraries.h2.value.ValueBigint;
import bending.libraries.h2.value.ValueNull;

public final class TableInfoFunction
extends Function1_2 {
    public static final int DISK_SPACE_USED = 0;
    public static final int ESTIMATED_ENVELOPE = 1;
    private static final String[] NAMES = new String[]{"DISK_SPACE_USED", "ESTIMATED_ENVELOPE"};
    private final int function;

    public TableInfoFunction(Expression expression, Expression expression2, int n) {
        super(expression, expression2);
        this.function = n;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal, Value value, Value value2) {
        Table table = new Parser(sessionLocal).parseTableName(value.getString());
        block0 : switch (this.function) {
            case 0: {
                value = ValueBigint.get(table.getDiskSpaceUsed(false, false));
                break;
            }
            case 1: {
                Column column = table.getColumn(value2.getString());
                for (Index index : table.getIndexes()) {
                    if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                    value = ((MVSpatialIndex)index).getEstimatedBounds(sessionLocal);
                    break block0;
                }
                value = ValueNull.INSTANCE;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return value;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.left = this.left.optimize(sessionLocal);
        if (this.right != null) {
            this.right = this.right.optimize(sessionLocal);
        }
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_GEOMETRY;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                return false;
            }
        }
        return super.isEverything(expressionVisitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

