/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.index;

import bending.libraries.h2.command.query.AllColumnsForPlan;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.index.Cursor;
import bending.libraries.h2.index.VirtualTableCursor;
import bending.libraries.h2.index.VirtualTableIndex;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.result.SearchRow;
import bending.libraries.h2.result.SortOrder;
import bending.libraries.h2.table.FunctionTable;
import bending.libraries.h2.table.IndexColumn;
import bending.libraries.h2.table.TableFilter;
import bending.libraries.h2.table.VirtualConstructedTable;

public class VirtualConstructedTableIndex
extends VirtualTableIndex {
    private final VirtualConstructedTable table;

    public VirtualConstructedTableIndex(VirtualConstructedTable virtualConstructedTable, IndexColumn[] indexColumnArray) {
        super(virtualConstructedTable, null, indexColumnArray);
        this.table = virtualConstructedTable;
    }

    @Override
    public boolean isFindUsingFullTableScan() {
        return true;
    }

    @Override
    public Cursor find(SessionLocal sessionLocal, SearchRow searchRow, SearchRow searchRow2, boolean bl) {
        assert (!bl);
        return new VirtualTableCursor(this, searchRow, searchRow2, this.table.getResult(sessionLocal));
    }

    @Override
    public double getCost(SessionLocal sessionLocal, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan, boolean bl) {
        if (nArray != null) {
            throw DbException.getUnsupportedException("Virtual table");
        }
        long l = this.table.canGetRowCount(sessionLocal) ? this.table.getRowCountApproximation(sessionLocal) : (long)this.database.getSettings().estimatedFunctionTableRows;
        return l * 10L;
    }

    @Override
    public String getPlanSQL() {
        return this.table instanceof FunctionTable ? "function" : "table scan";
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

