/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.mvstore.db;

import bending.libraries.h2.command.query.AllColumnsForPlan;
import bending.libraries.h2.engine.Database;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.index.Cursor;
import bending.libraries.h2.index.IndexType;
import bending.libraries.h2.index.SingleRowCursor;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.mvstore.MVMap;
import bending.libraries.h2.mvstore.MVStoreException;
import bending.libraries.h2.mvstore.db.MVIndex;
import bending.libraries.h2.mvstore.db.MVTable;
import bending.libraries.h2.mvstore.db.RowDataType;
import bending.libraries.h2.mvstore.tx.Transaction;
import bending.libraries.h2.mvstore.tx.TransactionMap;
import bending.libraries.h2.mvstore.type.LongDataType;
import bending.libraries.h2.result.Row;
import bending.libraries.h2.result.SearchRow;
import bending.libraries.h2.result.SortOrder;
import bending.libraries.h2.table.Column;
import bending.libraries.h2.table.IndexColumn;
import bending.libraries.h2.table.TableFilter;
import bending.libraries.h2.value.Value;
import bending.libraries.h2.value.ValueDecfloat;
import bending.libraries.h2.value.ValueLob;
import bending.libraries.h2.value.VersionedValue;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MVPrimaryIndex
extends MVIndex<Long, SearchRow> {
    private final MVTable mvTable;
    private final String mapName;
    private final TransactionMap<Long, SearchRow> dataMap;
    private final AtomicLong lastKey = new AtomicLong();
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database database, MVTable mVTable, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(mVTable, n, mVTable.getName() + "_DATA", indexColumnArray, 0, indexType);
        this.mvTable = mVTable;
        RowDataType rowDataType = mVTable.getRowFactory().getRowDataType();
        this.mapName = "table." + this.getId();
        Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(this.mapName, LongDataType.INSTANCE, rowDataType);
        this.dataMap.map.setVolatile(!mVTable.isPersistData() || !indexType.isPersistent());
        if (!database.isStarting()) {
            this.dataMap.clear();
        }
        transaction.commit();
        Long l = (Long)this.dataMap.map.lastKey();
        this.lastKey.set(l == null ? 0L : l);
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), 3).append(".tableScan").toString();
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(SessionLocal sessionLocal) {
    }

    @Override
    public void add(SessionLocal sessionLocal, Row row) {
        long l;
        Value value;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(this.lastKey.incrementAndGet());
            }
        } else {
            long l2 = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(l2);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value2 = row.getValue(i);
                if (!(value2 instanceof ValueLob)) continue;
                value = ((ValueLob)value2).copy(this.database, this.getId());
                sessionLocal.removeAtCommitStop((ValueLob)value);
                if (value2 == value) continue;
                row.setValue(i, value);
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        long l3 = row.getKey();
        try {
            value = (Row)transactionMap.putIfAbsent(l3, row);
            if (value != null) {
                int n = 90131;
                if (transactionMap.getImmediate(l3) != null || transactionMap.getFromSnapshot(l3) != null) {
                    n = 23505;
                }
                DbException dbException = DbException.get(n, this.getDuplicatePrimaryKeyMessage(this.mainIndexColumn).append(' ').append(value).toString());
                dbException.setSource(this);
                throw dbException;
            }
        }
        catch (MVStoreException mVStoreException) {
            throw this.mvTable.convertException(mVStoreException);
        }
        while (l3 > (l = this.lastKey.get()) && !this.lastKey.compareAndSet(l, l3)) {
        }
    }

    @Override
    public void remove(SessionLocal sessionLocal, Row row) {
        Object object;
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                object = row.getValue(i);
                if (!(object instanceof ValueLob)) continue;
                sessionLocal.removeAtCommit((ValueLob)object);
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        try {
            Row row2 = (Row)transactionMap.remove(row.getKey());
            if (row2 == null) {
                object = new StringBuilder();
                this.getSQL((StringBuilder)object, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, ((StringBuilder)object).toString());
            }
        }
        catch (MVStoreException mVStoreException) {
            throw this.mvTable.convertException(mVStoreException);
        }
    }

    @Override
    public void update(SessionLocal sessionLocal, Row row, Row row2) {
        Object object;
        long l;
        if (this.mainIndexColumn != -1) {
            l = row2.getValue(this.mainIndexColumn).getLong();
            row2.setKey(l);
        }
        l = row.getKey();
        assert (this.mainIndexColumn != -1 || l != 0L);
        assert (l == row2.getKey()) : l + " != " + row2.getKey();
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value;
                object = row.getValue(i);
                if (object == (value = row2.getValue(i))) continue;
                if (object instanceof ValueLob) {
                    sessionLocal.removeAtCommit((ValueLob)object);
                }
                if (!(value instanceof ValueLob)) continue;
                ValueLob valueLob = ((ValueLob)value).copy(this.database, this.getId());
                sessionLocal.removeAtCommitStop(valueLob);
                if (value == valueLob) continue;
                row2.setValue(i, valueLob);
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        try {
            Row row3 = (Row)transactionMap.put(l, row2);
            if (row3 == null) {
                object = new StringBuilder();
                this.getSQL((StringBuilder)object, 3).append(": ").append(l);
                throw DbException.get(90112, ((StringBuilder)object).toString());
            }
        }
        catch (MVStoreException mVStoreException) {
            throw this.mvTable.convertException(mVStoreException);
        }
        if (row2.getKey() > this.lastKey.get()) {
            this.lastKey.set(row2.getKey());
        }
    }

    Row lockRow(SessionLocal sessionLocal, Row row, int n) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        long l = row.getKey();
        return this.lockRow(transactionMap, l, n);
    }

    private Row lockRow(TransactionMap<Long, SearchRow> transactionMap, long l, int n) {
        try {
            return MVPrimaryIndex.setRowKey((Row)transactionMap.lock(l, n), l);
        }
        catch (MVStoreException mVStoreException) {
            throw this.mvTable.convertLockException(mVStoreException);
        }
    }

    @Override
    public Cursor find(SessionLocal sessionLocal, SearchRow searchRow, SearchRow searchRow2, boolean bl) {
        Long l;
        double d;
        Value value;
        Long l2;
        if (searchRow == null) {
            l2 = null;
        } else if (this.mainIndexColumn == -1 || (value = searchRow.getValue(this.mainIndexColumn)) == null) {
            l2 = searchRow.getKey();
        } else {
            switch (value.getValueType()) {
                case 0: {
                    return SingleRowCursor.EMPTY;
                }
                case 14: 
                case 15: {
                    d = value.getDouble();
                    if (Double.isNaN(d)) {
                        return SingleRowCursor.EMPTY;
                    }
                    l2 = (long)d;
                    break;
                }
                case 16: {
                    if (!((ValueDecfloat)value).isFinite()) {
                        if (value == ValueDecfloat.NEGATIVE_INFINITY) {
                            l2 = null;
                            break;
                        }
                        return SingleRowCursor.EMPTY;
                    }
                }
                case 13: {
                    BigDecimal bigDecimal = value.getBigDecimal();
                    if (bigDecimal.compareTo(Value.MAX_LONG_DECIMAL) > 0) {
                        return SingleRowCursor.EMPTY;
                    }
                    if (bigDecimal.compareTo(Value.MIN_LONG_DECIMAL) < 0) {
                        l2 = null;
                        break;
                    }
                    l2 = bigDecimal.longValue();
                    break;
                }
                default: {
                    l2 = value.getLong();
                }
            }
        }
        if (searchRow2 == null) {
            l = null;
        } else if (this.mainIndexColumn == -1 || (value = searchRow2.getValue(this.mainIndexColumn)) == null) {
            l = searchRow2.getKey();
        } else {
            switch (value.getValueType()) {
                case 0: {
                    return SingleRowCursor.EMPTY;
                }
                case 14: 
                case 15: {
                    d = value.getDouble();
                    if (Double.isNaN(d)) {
                        l = null;
                        break;
                    }
                    l = (long)d;
                    break;
                }
                case 16: {
                    if (!((ValueDecfloat)value).isFinite()) {
                        if (value == ValueDecfloat.NEGATIVE_INFINITY) {
                            return SingleRowCursor.EMPTY;
                        }
                        l = null;
                        break;
                    }
                }
                case 13: {
                    BigDecimal bigDecimal = value.getBigDecimal();
                    if (bigDecimal.compareTo(Value.MAX_LONG_DECIMAL) > 0) {
                        l = null;
                        break;
                    }
                    if (bigDecimal.compareTo(Value.MIN_LONG_DECIMAL) < 0) {
                        return SingleRowCursor.EMPTY;
                    }
                    l = bigDecimal.longValue();
                    break;
                }
                default: {
                    l = value.getLong();
                }
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        if (l2 != null && l != null && l2.longValue() == l.longValue()) {
            return new SingleRowCursor(MVPrimaryIndex.setRowKey((Row)transactionMap.getFromSnapshot(l2), l2));
        }
        return new MVStoreCursor(transactionMap.entryIterator(l2, l, bl));
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(SessionLocal sessionLocal, long l) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        Row row = (Row)transactionMap.getFromSnapshot(l);
        if (row == null) {
            throw DbException.get(90143, this.getTraceSQL(), String.valueOf(l));
        }
        return MVPrimaryIndex.setRowKey(row, l);
    }

    @Override
    public double getCost(SessionLocal sessionLocal, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan, boolean bl) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilterArray, n, sortOrder, true, allColumnsForPlan, bl);
        }
        catch (MVStoreException mVStoreException) {
            throw DbException.get(90007, mVStoreException, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return column.getColumnId() == -1 && column.getTable() == this.table;
    }

    @Override
    public void remove(SessionLocal sessionLocal) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        if (!transactionMap.isClosed()) {
            Transaction transaction = sessionLocal.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(SessionLocal sessionLocal) {
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.getMap(sessionLocal).clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(SessionLocal sessionLocal, boolean bl) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(sessionLocal);
        Map.Entry<Long, SearchRow> entry = bl ? transactionMap.firstEntry() : transactionMap.lastEntry();
        return entry != null ? new SingleRowCursor(MVPrimaryIndex.setRowKey((Row)entry.getValue(), entry.getKey())) : SingleRowCursor.EMPTY;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(SessionLocal sessionLocal) {
        return this.getMap(sessionLocal).sizeAsLong();
    }

    public long getRowCountMax() {
        return this.dataMap.sizeAsLongMax();
    }

    @Override
    public long getRowCountApproximation(SessionLocal sessionLocal) {
        return this.getRowCountMax();
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionMap<Long, SearchRow> getMap(SessionLocal sessionLocal) {
        if (sessionLocal == null) {
            return this.dataMap;
        }
        Transaction transaction = sessionLocal.getTransaction();
        return this.dataMap.getInstance(transaction);
    }

    @Override
    public MVMap<Long, VersionedValue<SearchRow>> getMVMap() {
        return this.dataMap.map;
    }

    private static Row setRowKey(Row row, long l) {
        if (row != null && row.getKey() == 0L) {
            row.setKey(l);
        }
        return row;
    }

    static final class MVStoreCursor
    implements Cursor {
        private final TransactionMap.TMIterator<Long, SearchRow, Map.Entry<Long, SearchRow>> it;
        private Map.Entry<Long, SearchRow> current;
        private Row row;

        public MVStoreCursor(TransactionMap.TMIterator<Long, SearchRow, Map.Entry<Long, SearchRow>> tMIterator) {
            this.it = tMIterator;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                this.row = (Row)this.current.getValue();
                if (this.row.getKey() == 0L) {
                    this.row.setKey(this.current.getKey());
                }
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.fetchNext();
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

