/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.table;

import bending.libraries.h2.command.Command;
import bending.libraries.h2.command.ParserBase;
import bending.libraries.h2.command.dml.Help;
import bending.libraries.h2.constraint.Constraint;
import bending.libraries.h2.constraint.ConstraintActionType;
import bending.libraries.h2.constraint.ConstraintDomain;
import bending.libraries.h2.constraint.ConstraintReferential;
import bending.libraries.h2.constraint.ConstraintUnique;
import bending.libraries.h2.engine.Constants;
import bending.libraries.h2.engine.DbObject;
import bending.libraries.h2.engine.QueryStatisticsData;
import bending.libraries.h2.engine.Right;
import bending.libraries.h2.engine.RightOwner;
import bending.libraries.h2.engine.Role;
import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.engine.User;
import bending.libraries.h2.expression.ExpressionVisitor;
import bending.libraries.h2.expression.ValueExpression;
import bending.libraries.h2.index.Index;
import bending.libraries.h2.index.MetaIndex;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.result.Row;
import bending.libraries.h2.result.SearchRow;
import bending.libraries.h2.schema.Constant;
import bending.libraries.h2.schema.Domain;
import bending.libraries.h2.schema.FunctionAlias;
import bending.libraries.h2.schema.Schema;
import bending.libraries.h2.schema.SchemaObject;
import bending.libraries.h2.schema.Sequence;
import bending.libraries.h2.schema.TriggerObject;
import bending.libraries.h2.schema.UserDefinedFunction;
import bending.libraries.h2.store.InDoubtTransaction;
import bending.libraries.h2.table.Column;
import bending.libraries.h2.table.IndexColumn;
import bending.libraries.h2.table.MetaTable;
import bending.libraries.h2.table.Table;
import bending.libraries.h2.table.TableSynonym;
import bending.libraries.h2.table.TableType;
import bending.libraries.h2.table.TableView;
import bending.libraries.h2.tools.Csv;
import bending.libraries.h2.util.DateTimeUtils;
import bending.libraries.h2.util.MathUtils;
import bending.libraries.h2.util.NetworkConnectionInfo;
import bending.libraries.h2.util.StringUtils;
import bending.libraries.h2.util.TimeZoneProvider;
import bending.libraries.h2.util.Utils;
import bending.libraries.h2.value.CompareMode;
import bending.libraries.h2.value.DataType;
import bending.libraries.h2.value.TypeInfo;
import bending.libraries.h2.value.Value;
import bending.libraries.h2.value.ValueBigint;
import bending.libraries.h2.value.ValueBoolean;
import bending.libraries.h2.value.ValueDouble;
import bending.libraries.h2.value.ValueInteger;
import bending.libraries.h2.value.ValueSmallint;
import bending.libraries.h2.value.ValueToObjectConverter2;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Locale;

public final class InformationSchemaTableLegacy
extends MetaTable {
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int FUNCTION_COLUMNS = 20;
    private static final int CONSTRAINTS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int DOMAIN_CONSTRAINTS = 31;
    private static final int KEY_COLUMN_USAGE = 32;
    private static final int REFERENTIAL_CONSTRAINTS = 33;
    private static final int CHECK_CONSTRAINTS = 34;
    private static final int CONSTRAINT_COLUMN_USAGE = 35;
    public static final int META_TABLE_TYPE_COUNT = 36;

    public InformationSchemaTableLegacy(Schema schema, int n, int n2) {
        super(schema, n, n2);
        Column[] columnArray;
        String string = null;
        switch (n2) {
            case 0: {
                this.setMetaTableName("TABLES");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("TABLE_TYPE"), this.column("STORAGE_TYPE"), this.column("SQL"), this.column("REMARKS"), this.column("LAST_MODIFICATION", TypeInfo.TYPE_BIGINT), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("TABLE_CLASS"), this.column("ROW_COUNT_ESTIMATE", TypeInfo.TYPE_BIGINT)};
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_GENERATED"), this.column("GENERATION_EXPRESSION"), this.column("TYPE_NAME"), this.column("NULLABLE", TypeInfo.TYPE_INTEGER), this.column("IS_COMPUTED", TypeInfo.TYPE_BOOLEAN), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("SEQUENCE_NAME"), this.column("REMARKS"), this.column("SOURCE_DATA_TYPE", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_TYPE"), this.column("COLUMN_ON_UPDATE"), this.column("IS_VISIBLE"), this.column("CHECK_CONSTRAINT")};
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("NON_UNIQUE", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_NAME"), this.column("CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("PRIMARY_KEY", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_TYPE_NAME"), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_TYPE", TypeInfo.TYPE_SMALLINT), this.column("ASC_OR_DESC"), this.column("PAGES", TypeInfo.TYPE_INTEGER), this.column("FILTER_CONDITION"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SORT_TYPE", TypeInfo.TYPE_INTEGER), this.column("CONSTRAINT_NAME"), this.column("INDEX_CLASS")};
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                columnArray = new Column[]{this.column("TYPE")};
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                columnArray = new Column[]{this.column("TYPE_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("PREFIX"), this.column("SUFFIX"), this.column("PARAMS"), this.column("AUTO_INCREMENT", TypeInfo.TYPE_BOOLEAN), this.column("MINIMUM_SCALE", TypeInfo.TYPE_SMALLINT), this.column("MAXIMUM_SCALE", TypeInfo.TYPE_SMALLINT), this.column("RADIX", TypeInfo.TYPE_INTEGER), this.column("POS", TypeInfo.TYPE_INTEGER), this.column("CASE_SENSITIVE", TypeInfo.TYPE_BOOLEAN), this.column("NULLABLE", TypeInfo.TYPE_SMALLINT), this.column("SEARCHABLE", TypeInfo.TYPE_SMALLINT)};
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                columnArray = new Column[]{this.column("CATALOG_NAME")};
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                columnArray = new Column[]{this.column("NAME"), this.column("VALUE")};
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                columnArray = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SECTION"), this.column("TOPIC"), this.column("SYNTAX"), this.column("TEXT")};
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                columnArray = new Column[]{this.column("SEQUENCE_CATALOG"), this.column("SEQUENCE_SCHEMA"), this.column("SEQUENCE_NAME"), this.column("DATA_TYPE"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("START_VALUE", TypeInfo.TYPE_BIGINT), this.column("MINIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAXIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("INCREMENT", TypeInfo.TYPE_BIGINT), this.column("CYCLE_OPTION"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("CURRENT_VALUE", TypeInfo.TYPE_BIGINT), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("CACHE", TypeInfo.TYPE_BIGINT), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("MIN_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAX_VALUE", TypeInfo.TYPE_BIGINT), this.column("IS_CYCLE", TypeInfo.TYPE_BOOLEAN)};
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                columnArray = new Column[]{this.column("NAME"), this.column("ADMIN"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                columnArray = new Column[]{this.column("NAME"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                columnArray = new Column[]{this.column("GRANTEE"), this.column("GRANTEETYPE"), this.column("GRANTEDROLE"), this.column("RIGHTS"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                columnArray = new Column[]{this.column("ALIAS_CATALOG"), this.column("ALIAS_SCHEMA"), this.column("ALIAS_NAME"), this.column("JAVA_CLASS"), this.column("JAVA_METHOD"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("COLUMN_COUNT", TypeInfo.TYPE_INTEGER), this.column("RETURNS_RESULT", TypeInfo.TYPE_SMALLINT), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SOURCE")};
                break;
            }
            case 20: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                columnArray = new Column[]{this.column("ALIAS_CATALOG"), this.column("ALIAS_SCHEMA"), this.column("ALIAS_NAME"), this.column("JAVA_CLASS"), this.column("JAVA_METHOD"), this.column("COLUMN_COUNT", TypeInfo.TYPE_INTEGER), this.column("POS", TypeInfo.TYPE_INTEGER), this.column("COLUMN_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("SCALE", TypeInfo.TYPE_SMALLINT), this.column("RADIX", TypeInfo.TYPE_SMALLINT), this.column("NULLABLE", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_TYPE", TypeInfo.TYPE_SMALLINT), this.column("REMARKS"), this.column("COLUMN_DEFAULT")};
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                columnArray = new Column[]{this.column("CATALOG_NAME"), this.column("SCHEMA_NAME"), this.column("SCHEMA_OWNER"), this.column("DEFAULT_CHARACTER_SET_NAME"), this.column("DEFAULT_COLLATION_NAME"), this.column("IS_DEFAULT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                columnArray = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                columnArray = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                columnArray = new Column[]{this.column("NAME"), this.column("KEY")};
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("VIEW_DEFINITION"), this.column("CHECK_OPTION"), this.column("IS_UPDATABLE"), this.column("STATUS"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                columnArray = new Column[]{this.column("TRANSACTION"), this.column("STATE")};
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                columnArray = new Column[]{this.column("PKTABLE_CATALOG"), this.column("PKTABLE_SCHEMA"), this.column("PKTABLE_NAME"), this.column("PKCOLUMN_NAME"), this.column("FKTABLE_CATALOG"), this.column("FKTABLE_SCHEMA"), this.column("FKTABLE_NAME"), this.column("FKCOLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT), this.column("UPDATE_RULE", TypeInfo.TYPE_SMALLINT), this.column("DELETE_RULE", TypeInfo.TYPE_SMALLINT), this.column("FK_NAME"), this.column("PK_NAME"), this.column("DEFERRABILITY", TypeInfo.TYPE_SMALLINT)};
                string = "PKTABLE_NAME";
                break;
            }
            case 21: {
                this.setMetaTableName("CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("UNIQUE_INDEX_NAME"), this.column("CHECK_EXPRESSION"), this.column("COLUMN_LIST"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("CONSTANTS");
                columnArray = new Column[]{this.column("CONSTANT_CATALOG"), this.column("CONSTANT_SCHEMA"), this.column("CONSTANT_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 23: {
                this.setMetaTableName("DOMAINS");
                columnArray = new Column[]{this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("DOMAIN_DEFAULT"), this.column("DOMAIN_ON_UPDATE"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("SCALE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("PARENT_DOMAIN_CATALOG"), this.column("PARENT_DOMAIN_SCHEMA"), this.column("PARENT_DOMAIN_NAME"), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("CHECK_CONSTRAINT")};
                break;
            }
            case 24: {
                this.setMetaTableName("TRIGGERS");
                columnArray = new Column[]{this.column("TRIGGER_CATALOG"), this.column("TRIGGER_SCHEMA"), this.column("TRIGGER_NAME"), this.column("TRIGGER_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("BEFORE", TypeInfo.TYPE_BOOLEAN), this.column("JAVA_CLASS"), this.column("QUEUE_SIZE", TypeInfo.TYPE_INTEGER), this.column("NO_WAIT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 25: {
                this.setMetaTableName("SESSIONS");
                columnArray = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("USER_NAME"), this.column("SERVER"), this.column("CLIENT_ADDR"), this.column("CLIENT_INFO"), this.column("SESSION_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("ISOLATION_LEVEL"), this.column("STATEMENT"), this.column("STATEMENT_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("CONTAINS_UNCOMMITTED", TypeInfo.TYPE_BOOLEAN), this.column("STATE"), this.column("BLOCKER_ID", TypeInfo.TYPE_INTEGER), this.column("SLEEP_SINCE", TypeInfo.TYPE_TIMESTAMP_TZ)};
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                columnArray = new Column[]{this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("SESSION_ID", TypeInfo.TYPE_INTEGER), this.column("LOCK_TYPE")};
                break;
            }
            case 27: {
                this.setMetaTableName("SESSION_STATE");
                columnArray = new Column[]{this.column("KEY"), this.column("SQL")};
                break;
            }
            case 28: {
                this.setMetaTableName("QUERY_STATISTICS");
                columnArray = new Column[]{this.column("SQL_STATEMENT"), this.column("EXECUTION_COUNT", TypeInfo.TYPE_INTEGER), this.column("MIN_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MAX_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("CUMULATIVE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("AVERAGE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MIN_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("MAX_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("CUMULATIVE_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("AVERAGE_ROW_COUNT", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_ROW_COUNT", TypeInfo.TYPE_DOUBLE)};
                break;
            }
            case 29: {
                this.setMetaTableName("SYNONYMS");
                columnArray = new Column[]{this.column("SYNONYM_CATALOG"), this.column("SYNONYM_SCHEMA"), this.column("SYNONYM_NAME"), this.column("SYNONYM_FOR"), this.column("SYNONYM_FOR_SCHEMA"), this.column("TYPE_NAME"), this.column("STATUS"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setMetaTableName("DOMAIN_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 32: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("POSITION_IN_UNIQUE_CONSTRAINT", TypeInfo.TYPE_INTEGER), this.column("INDEX_CATALOG"), this.column("INDEX_SCHEMA"), this.column("INDEX_NAME")};
                string = "TABLE_NAME";
                break;
            }
            case 33: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("UNIQUE_CONSTRAINT_CATALOG"), this.column("UNIQUE_CONSTRAINT_SCHEMA"), this.column("UNIQUE_CONSTRAINT_NAME"), this.column("MATCH_OPTION"), this.column("UPDATE_RULE"), this.column("DELETE_RULE")};
                break;
            }
            case 34: {
                this.setMetaTableName("CHECK_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CHECK_CLAUSE")};
                break;
            }
            case 35: {
                this.setMetaTableName("CONSTRAINT_COLUMN_USAGE");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME")};
                string = "TABLE_NAME";
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(string)).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    @Override
    public ArrayList<Row> generateRows(SessionLocal sessionLocal, SearchRow searchRow, SearchRow searchRow2) {
        Value value = this.indexColumn >= 0 && searchRow != null ? searchRow.getValue(this.indexColumn) : null;
        Value value2 = this.indexColumn >= 0 && searchRow2 != null ? searchRow2.getValue(this.indexColumn) : null;
        ArrayList<Row> arrayList = Utils.newSmallArrayList();
        String string3 = this.database.getShortName();
        boolean bl = sessionLocal.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                this.getAllTables(sessionLocal, value, value2).forEach(table -> {
                    String string2 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    String string3 = table.getCreateSQL();
                    if (!bl && string3 != null && string3.contains("--hide--")) {
                        string3 = "-";
                    }
                    this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), table.getTableType().toString(), string2, string3, InformationSchemaTableLegacy.replaceNullWithEmpty(table.getComment()), ValueBigint.get(table.getMaxDataModificationId()), ValueInteger.get(table.getId()), null, table.getClass().getName(), ValueBigint.get(table.getRowCountApproximation(sessionLocal)));
                });
                break;
            }
            case 1: {
                this.getAllTables(sessionLocal, value, value2).forEach(table -> {
                    Column[] columnArray = table.getColumns();
                    String string2 = this.database.getCompareMode().getName();
                    for (int i = 0; i < columnArray.length; ++i) {
                        boolean bl;
                        Column column = columnArray[i];
                        Domain domain = column.getDomain();
                        TypeInfo typeInfo = column.getType();
                        ValueInteger valueInteger = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                        ValueInteger valueInteger2 = ValueInteger.get(typeInfo.getScale());
                        Sequence sequence = column.getSequence();
                        int n = typeInfo.getValueType();
                        switch (n) {
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 27: 
                            case 31: 
                            case 33: 
                            case 34: {
                                bl = true;
                                break;
                            }
                            default: {
                                bl = false;
                            }
                        }
                        boolean bl2 = column.isGenerated();
                        boolean bl3 = DataType.isIntervalType(n);
                        String string3 = column.getCreateSQLWithoutName();
                        this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), column.getName(), ValueInteger.get(i + 1), bl2 ? null : column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), valueInteger, valueInteger, valueInteger, ValueInteger.get(10), valueInteger2, bl ? valueInteger2 : null, bl3 ? string3.substring(9) : null, bl3 ? valueInteger : null, CHARACTER_SET_NAME, string2, domain != null ? string3 : null, domain != null ? domain.getSchema().getName() : null, domain != null ? domain.getName() : null, bl2 ? "ALWAYS" : "NEVER", bl2 ? column.getDefaultSQL() : null, this.identifier(bl3 ? "INTERVAL" : typeInfo.getDeclaredTypeName()), ValueInteger.get(column.isNullable() ? 1 : 0), ValueBoolean.get(bl2), ValueInteger.get(column.getSelectivity()), sequence == null ? null : sequence.getName(), InformationSchemaTableLegacy.replaceNullWithEmpty(column.getComment()), null, string3, column.getOnUpdateSQL(), ValueBoolean.get(column.getVisible()), null);
                    }
                });
                break;
            }
            case 2: {
                this.getAllTables(sessionLocal, value, value2).forEach(table -> {
                    Iterable<Constraint> iterable = table.getConstraints();
                    for (Index index : table.getIndexes()) {
                        if (index.getCreateSQL() == null) continue;
                        String string2 = null;
                        for (Constraint constraint : iterable) {
                            if (!constraint.usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                string2 = constraint.getName();
                                continue;
                            }
                            string2 = constraint.getName();
                        }
                        IndexColumn[] indexColumnArray = index.getIndexColumns();
                        int n = index.getUniqueColumnCount();
                        String string3 = index.getClass().getName();
                        for (int i = 0; i < indexColumnArray.length; ++i) {
                            IndexColumn indexColumn = indexColumnArray[i];
                            Column column = indexColumn.column;
                            this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), ValueBoolean.get(i >= n), index.getName(), ValueSmallint.get((short)(i + 1)), column.getName(), ValueInteger.get(0), ValueBoolean.get(index.getIndexType().isPrimaryKey()), index.getIndexType().getSQL(false), ValueBoolean.get(index.getIndexType().getBelongsToConstraint()), ValueSmallint.get((short)3), (indexColumn.sortType & 1) != 0 ? "D" : "A", ValueInteger.get(0), "", InformationSchemaTableLegacy.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), ValueInteger.get(index.getId()), ValueInteger.get(indexColumn.sortType), string2, string3);
                        }
                    }
                });
                break;
            }
            case 3: {
                this.add(sessionLocal, arrayList, TableType.TABLE.toString());
                this.add(sessionLocal, arrayList, TableType.TABLE_LINK.toString());
                this.add(sessionLocal, arrayList, TableType.SYSTEM_TABLE.toString());
                this.add(sessionLocal, arrayList, TableType.VIEW.toString());
                this.add(sessionLocal, arrayList, TableType.EXTERNAL_TABLE_ENGINE.toString());
                break;
            }
            case 4: {
                int n = 42;
                for (int i = 1; i < n; ++i) {
                    DataType dataType = DataType.getDataType(i);
                    this.add(sessionLocal, arrayList, Value.getTypeName(dataType.type), ValueInteger.get(dataType.sqlType), ValueInteger.get(MathUtils.convertLongToInt(dataType.maxPrecision)), dataType.prefix, dataType.suffix, dataType.params, ValueBoolean.FALSE, ValueSmallint.get(MathUtils.convertIntToShort(dataType.minScale)), ValueSmallint.get(MathUtils.convertIntToShort(dataType.maxScale)), DataType.isNumericType(i) ? ValueInteger.get(10) : null, ValueInteger.get(dataType.type), ValueBoolean.get(dataType.caseSensitive), ValueSmallint.get((short)1), ValueSmallint.get((short)3));
                }
                break;
            }
            case 5: {
                this.add(sessionLocal, arrayList, string3);
                break;
            }
            case 6: {
                Object object = this.database.getAllSettings().iterator();
                while (object.hasNext()) {
                    String[] stringArray = object.next();
                    String string4 = stringArray.getStringValue();
                    if (string4 == null) {
                        string4 = Integer.toString(stringArray.getIntValue());
                    }
                    this.add(sessionLocal, arrayList, this.identifier(stringArray.getName()), string4);
                }
                this.add(sessionLocal, arrayList, "info.BUILD_ID", "240");
                this.add(sessionLocal, arrayList, "info.VERSION_MAJOR", "2");
                this.add(sessionLocal, arrayList, "info.VERSION_MINOR", "4");
                this.add(sessionLocal, arrayList, "info.VERSION", Constants.FULL_VERSION);
                if (bl) {
                    for (String string5 : object = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"}) {
                        this.add(sessionLocal, arrayList, "property." + string5, Utils.getProperty(string5, ""));
                    }
                }
                this.add(sessionLocal, arrayList, "QUERY_TIMEOUT", Integer.toString(sessionLocal.getQueryTimeout()));
                this.add(sessionLocal, arrayList, "TIME ZONE", sessionLocal.currentTimeZone().getId());
                this.add(sessionLocal, arrayList, "TRUNCATE_LARGE_LENGTH", sessionLocal.isTruncateLargeLength() ? "TRUE" : "FALSE");
                this.add(sessionLocal, arrayList, "VARIABLE_BINARY", sessionLocal.isVariableBinary() ? "TRUE" : "FALSE");
                this.add(sessionLocal, arrayList, "OLD_INFORMATION_SCHEMA", sessionLocal.isOldInformationSchema() ? "TRUE" : "FALSE");
                object = sessionLocal.getNonKeywords();
                if (object != null) {
                    this.add(sessionLocal, arrayList, "NON_KEYWORDS", ParserBase.formatNonKeywords((BitSet)object));
                }
                this.database.populateInfo((string, string2) -> this.add(sessionLocal, arrayList, string, string2));
                break;
            }
            case 7: {
                String string6 = "/bending/libraries/h2/res/help.csv";
                try {
                    byte[] byArray = Utils.getResource(string6);
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), StandardCharsets.UTF_8);
                    Csv csv = new Csv();
                    csv.setLineCommentCharacter('#');
                    ResultSet resultSet = csv.read(inputStreamReader, null);
                    int n = resultSet.getMetaData().getColumnCount() - 1;
                    String[] stringArray = new String[5];
                    int n2 = 0;
                    while (resultSet.next()) {
                        for (int i = 0; i < n; ++i) {
                            String string7 = resultSet.getString(1 + i);
                            switch (i) {
                                case 2: {
                                    string7 = Help.stripAnnotationsFromSyntax(string7);
                                    break;
                                }
                                case 3: {
                                    string7 = Help.processHelpText(string7);
                                }
                            }
                            stringArray[i] = string7.trim();
                        }
                        this.add(sessionLocal, arrayList, ValueInteger.get(n2), stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
                        ++n2;
                    }
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            case 8: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
                    Sequence sequence = (Sequence)schemaObject;
                    TypeInfo typeInfo = sequence.getDataType();
                    String string8 = Value.getTypeName(typeInfo.getValueType());
                    ValueInteger valueInteger = ValueInteger.get(typeInfo.getScale());
                    this.add(sessionLocal, arrayList, string3, sequence.getSchema().getName(), sequence.getName(), string8, ValueInteger.get(sequence.getEffectivePrecision()), ValueInteger.get(10), valueInteger, ValueBigint.get(sequence.getStartValue()), ValueBigint.get(sequence.getMinValue()), ValueBigint.get(sequence.getMaxValue()), ValueBigint.get(sequence.getIncrement()), sequence.getCycle().isCycle() ? "YES" : "NO", string8, ValueInteger.get((int)typeInfo.getPrecision()), valueInteger, ValueBigint.get(sequence.getCurrentValue()), ValueBoolean.get(sequence.getBelongsToTable()), InformationSchemaTableLegacy.replaceNullWithEmpty(sequence.getComment()), ValueBigint.get(sequence.getCacheSize()), ValueInteger.get(sequence.getId()), ValueBigint.get(sequence.getMinValue()), ValueBigint.get(sequence.getMaxValue()), ValueBoolean.get(sequence.getCycle().isCycle()));
                }
                break;
            }
            case 9: {
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof User)) continue;
                    User user = (User)rightOwner;
                    if (!bl && sessionLocal.getUser() != user) continue;
                    this.add(sessionLocal, arrayList, this.identifier(user.getName()), String.valueOf(user.isAdmin()), InformationSchemaTableLegacy.replaceNullWithEmpty(user.getComment()), ValueInteger.get(user.getId()));
                }
                break;
            }
            case 10: {
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof Role)) continue;
                    Role role = (Role)rightOwner;
                    if (!bl && !sessionLocal.getUser().isRoleGranted(role)) continue;
                    this.add(sessionLocal, arrayList, this.identifier(role.getName()), InformationSchemaTableLegacy.replaceNullWithEmpty(role.getComment()), ValueInteger.get(role.getId()));
                }
                break;
            }
            case 11: {
                if (!bl) break;
                for (Right right : this.database.getAllRights()) {
                    String string9;
                    Role role = right.getGrantedRole();
                    DbObject dbObject = right.getGrantee();
                    String string10 = string9 = dbObject.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        String string11;
                        DbObject dbObject2 = right.getGrantedObject();
                        Schema schema = null;
                        DbObject dbObject3 = null;
                        if (dbObject2 != null) {
                            if (dbObject2 instanceof Schema) {
                                schema = (Schema)dbObject2;
                            } else if (dbObject2 instanceof Table) {
                                dbObject3 = (Table)dbObject2;
                                schema = ((SchemaObject)dbObject3).getSchema();
                            }
                        }
                        String string12 = dbObject3 != null ? dbObject3.getName() : "";
                        String string13 = string11 = schema != null ? schema.getName() : "";
                        if (!this.checkIndex(sessionLocal, string12, value, value2)) continue;
                        this.add(sessionLocal, arrayList, this.identifier(dbObject.getName()), string9, "", right.getRights(), string11, string12, ValueInteger.get(right.getId()));
                        continue;
                    }
                    this.add(sessionLocal, arrayList, this.identifier(dbObject.getName()), string9, this.identifier(role.getName()), "", "", "", ValueInteger.get(right.getId()));
                }
                break;
            }
            case 12: {
                for (Schema schema : this.database.getAllSchemas()) {
                    for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                        if (userDefinedFunction instanceof FunctionAlias) {
                            FunctionAlias.JavaMethod[] javaMethodArray;
                            FunctionAlias functionAlias = (FunctionAlias)userDefinedFunction;
                            try {
                                javaMethodArray = functionAlias.getJavaMethods();
                            }
                            catch (DbException dbException) {
                                continue;
                            }
                            for (FunctionAlias.JavaMethod javaMethod : javaMethodArray) {
                                TypeInfo typeInfo = javaMethod.getDataType();
                                if (typeInfo == null) {
                                    typeInfo = TypeInfo.TYPE_NULL;
                                }
                                this.add(sessionLocal, arrayList, string3, functionAlias.getSchema().getName(), functionAlias.getName(), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), typeInfo.getDeclaredTypeName(), ValueInteger.get(javaMethod.getParameterCount()), ValueSmallint.get(typeInfo.getValueType() == 0 ? (short)1 : 2), InformationSchemaTableLegacy.replaceNullWithEmpty(functionAlias.getComment()), ValueInteger.get(functionAlias.getId()), functionAlias.getSource());
                            }
                            continue;
                        }
                        this.add(sessionLocal, arrayList, string3, this.database.getMainSchema().getName(), userDefinedFunction.getName(), userDefinedFunction.getJavaClassName(), "", ValueInteger.get(0), "NULL", ValueInteger.get(1), ValueSmallint.get((short)2), InformationSchemaTableLegacy.replaceNullWithEmpty(userDefinedFunction.getComment()), ValueInteger.get(userDefinedFunction.getId()), "");
                    }
                }
                break;
            }
            case 20: {
                for (Schema schema : this.database.getAllSchemas()) {
                    for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                        FunctionAlias.JavaMethod[] javaMethodArray;
                        if (!(userDefinedFunction instanceof FunctionAlias)) continue;
                        FunctionAlias functionAlias = (FunctionAlias)userDefinedFunction;
                        try {
                            javaMethodArray = functionAlias.getJavaMethods();
                        }
                        catch (DbException dbException) {
                            continue;
                        }
                        for (FunctionAlias.JavaMethod javaMethod : javaMethodArray) {
                            Object object;
                            TypeInfo typeInfo = javaMethod.getDataType();
                            if (typeInfo != null && typeInfo.getValueType() != 0) {
                                object = DataType.getDataType(typeInfo.getValueType());
                                this.add(sessionLocal, arrayList, string3, functionAlias.getSchema().getName(), functionAlias.getName(), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), ValueInteger.get(javaMethod.getParameterCount()), ValueInteger.get(0), "P0", ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), typeInfo.getDeclaredTypeName(), ValueInteger.get(MathUtils.convertLongToInt(object.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(object.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get((short)2), ValueSmallint.get((short)5), "", null);
                            }
                            object = javaMethod.getColumnClasses();
                            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                                if (javaMethod.hasConnectionParam() && i == 0) continue;
                                Class<?> clazz = object[i];
                                TypeInfo typeInfo2 = ValueToObjectConverter2.classToType(clazz);
                                DataType dataType = DataType.getDataType(typeInfo2.getValueType());
                                this.add(sessionLocal, arrayList, string3, functionAlias.getSchema().getName(), functionAlias.getName(), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), ValueInteger.get(javaMethod.getParameterCount()), ValueInteger.get(i + (javaMethod.hasConnectionParam() ? 0 : 1)), "P" + (i + 1), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo2)), typeInfo2.getDeclaredTypeName(), ValueInteger.get(MathUtils.convertLongToInt(dataType.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(dataType.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get(clazz.isPrimitive() ? (short)0 : 1), ValueSmallint.get((short)1), "", null);
                            }
                        }
                    }
                }
                break;
            }
            case 13: {
                String string14 = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(sessionLocal, arrayList, string3, schema.getName(), this.identifier(schema.getOwner().getName()), CHARACTER_SET_NAME, string14, ValueBoolean.get(schema.getId() == 0), InformationSchemaTableLegacy.replaceNullWithEmpty(schema.getComment()), ValueInteger.get(schema.getId()));
                }
                break;
            }
            case 14: {
                for (Right right : this.database.getAllRights()) {
                    Table table2;
                    DbObject dbObject = right.getGrantedObject();
                    if (!(dbObject instanceof Table) || !this.checkIndex(sessionLocal, (table2 = (Table)dbObject).getName(), value, value2)) continue;
                    this.addPrivileges(sessionLocal, arrayList, right.getGrantee(), string3, table2, null, right.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right right : this.database.getAllRights()) {
                    Table table3;
                    DbObject dbObject = right.getGrantedObject();
                    if (!(dbObject instanceof Table) || !this.checkIndex(sessionLocal, (table3 = (Table)dbObject).getName(), value, value2)) continue;
                    DbObject dbObject4 = right.getGrantee();
                    int n = right.getRightMask();
                    for (Column column : table3.getColumns()) {
                        this.addPrivileges(sessionLocal, arrayList, dbObject4, string3, table3, column.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale locale : CompareMode.getCollationLocales(false)) {
                    this.add(sessionLocal, arrayList, CompareMode.getName(locale), locale.toString());
                }
                break;
            }
            case 17: {
                this.getAllTables(sessionLocal, value, value2).filter(Table::isView).forEach(table -> this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), table.getCreateSQL(), "NONE", "NO", table instanceof TableView && ((TableView)table).isInvalid() ? "INVALID" : "VALID", InformationSchemaTableLegacy.replaceNullWithEmpty(table.getComment()), ValueInteger.get(table.getId())));
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList2 = this.database.getInDoubtTransactions();
                if (arrayList2 == null || !bl) break;
                for (InDoubtTransaction inDoubtTransaction : arrayList2) {
                    this.add(sessionLocal, arrayList, inDoubtTransaction.getTransactionName(), inDoubtTransaction.getStateDescription());
                }
                break;
            }
            case 19: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() == Constraint.Type.REFERENTIAL && this.checkIndex(sessionLocal, constraint.getName(), value, value2)).forEach(constraint -> {
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = constraintReferential.getColumns();
                    IndexColumn[] indexColumnArray2 = constraintReferential.getRefColumns();
                    Table table = constraintReferential.getTable();
                    Table table2 = constraintReferential.getRefTable();
                    ValueSmallint valueSmallint = ValueSmallint.get(InformationSchemaTableLegacy.getRefAction(constraintReferential.getUpdateAction()));
                    ValueSmallint valueSmallint2 = ValueSmallint.get(InformationSchemaTableLegacy.getRefAction(constraintReferential.getDeleteAction()));
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(sessionLocal, arrayList, string3, table2.getSchema().getName(), table2.getName(), indexColumnArray2[i].column.getName(), string3, table.getSchema().getName(), table.getName(), indexColumnArray[i].column.getName(), ValueSmallint.get((short)(i + 1)), valueSmallint, valueSmallint2, constraintReferential.getName(), constraintReferential.getReferencedConstraint().getName(), ValueSmallint.get((short)7));
                    }
                });
                break;
            }
            case 21: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() != Constraint.Type.DOMAIN && this.checkIndex(sessionLocal, constraint.getTable().getName(), value, value2)).forEach(constraint -> {
                    Constraint.Type type = constraint.getConstraintType();
                    String string2 = null;
                    IndexColumn[] indexColumnArray = null;
                    Table table = constraint.getTable();
                    Index index = constraint.getIndex();
                    String string3 = null;
                    if (index != null) {
                        string3 = index.getName();
                    }
                    if (type == Constraint.Type.CHECK) {
                        string2 = constraint.getExpression().getSQL(0);
                    } else if (type.isUnique()) {
                        indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (type == Constraint.Type.REFERENTIAL) {
                        indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string4 = null;
                    if (indexColumnArray != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n = indexColumnArray.length;
                        for (int i = 0; i < n; ++i) {
                            if (i > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(indexColumnArray[i].column.getName());
                        }
                        string4 = stringBuilder.toString();
                    }
                    this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), type == Constraint.Type.PRIMARY_KEY ? type.getSqlName() : type.name(), string3, table.getSchema().getName(), table.getName(), string3, string2, string4, InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                });
                break;
            }
            case 22: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)schemaObject;
                    ValueExpression valueExpression = constant.getValue();
                    this.add(sessionLocal, arrayList, string3, constant.getSchema().getName(), constant.getName(), ValueInteger.get(DataType.convertTypeToSQLType(valueExpression.getType())), InformationSchemaTableLegacy.replaceNullWithEmpty(constant.getComment()), valueExpression.getSQL(0), ValueInteger.get(constant.getId()));
                }
                break;
            }
            case 23: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(12)) {
                    Domain domain = (Domain)schemaObject;
                    Domain domain2 = domain.getDomain();
                    TypeInfo typeInfo = domain.getDataType();
                    this.add(sessionLocal, arrayList, string3, domain.getSchema().getName(), domain.getName(), domain.getDefaultSQL(), domain.getOnUpdateSQL(), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision())), ValueInteger.get(typeInfo.getScale()), typeInfo.getDeclaredTypeName(), domain2 != null ? string3 : null, domain2 != null ? domain2.getSchema().getName() : null, domain2 != null ? domain2.getName() : null, ValueInteger.get(50), InformationSchemaTableLegacy.replaceNullWithEmpty(domain.getComment()), domain.getCreateSQL(), ValueInteger.get(domain.getId()), domain.getDefaultSQL(), "YES", null);
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)schemaObject;
                    Table table4 = triggerObject.getTable();
                    this.add(sessionLocal, arrayList, string3, triggerObject.getSchema().getName(), triggerObject.getName(), triggerObject.getTypeNameList(new StringBuilder()).toString(), string3, table4.getSchema().getName(), table4.getName(), ValueBoolean.get(triggerObject.isBefore()), triggerObject.getTriggerClassName(), ValueInteger.get(triggerObject.getQueueSize()), ValueBoolean.get(triggerObject.isNoWait()), InformationSchemaTableLegacy.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), ValueInteger.get(triggerObject.getId()));
                }
                break;
            }
            case 25: {
                for (SessionLocal sessionLocal2 : this.database.getSessions(false)) {
                    if (!bl && sessionLocal2 != sessionLocal) continue;
                    NetworkConnectionInfo networkConnectionInfo = sessionLocal2.getNetworkConnectionInfo();
                    Command command = sessionLocal2.getCurrentCommand();
                    int n = sessionLocal2.getBlockingSessionId();
                    this.add(sessionLocal, arrayList, ValueInteger.get(sessionLocal2.getId()), sessionLocal2.getUser().getName(), networkConnectionInfo == null ? null : networkConnectionInfo.getServer(), networkConnectionInfo == null ? null : networkConnectionInfo.getClient(), networkConnectionInfo == null ? null : networkConnectionInfo.getClientInfo(), sessionLocal2.getSessionStart(), sessionLocal2.getIsolationLevel().getSQL(), command == null ? null : command.toString(), command == null ? null : sessionLocal2.getCommandStartOrEnd(), ValueBoolean.get(sessionLocal2.hasPendingTransaction()), String.valueOf((Object)sessionLocal2.getState()), n == 0 ? null : ValueInteger.get(n), sessionLocal2.getState() == SessionLocal.State.SLEEP ? sessionLocal2.getCommandStartOrEnd() : null);
                }
                break;
            }
            case 26: {
                for (SessionLocal sessionLocal3 : this.database.getSessions(false)) {
                    if (!bl && sessionLocal3 != sessionLocal) continue;
                    for (Table table5 : sessionLocal3.getLocks()) {
                        this.add(sessionLocal, arrayList, table5.getSchema().getName(), table5.getName(), ValueInteger.get(sessionLocal3.getId()), table5.isLockedExclusivelyBy(sessionLocal3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                TimeZoneProvider timeZoneProvider;
                String string15;
                for (String string16 : sessionLocal.getVariableNames()) {
                    Value value3 = sessionLocal.getVariable(string16);
                    StringBuilder stringBuilder = new StringBuilder().append("SET @").append(string16).append(' ');
                    value3.getSQL(stringBuilder, 0);
                    this.add(sessionLocal, arrayList, "@" + string16, stringBuilder.toString());
                }
                for (Table table6 : sessionLocal.getLocalTempTables()) {
                    this.add(sessionLocal, arrayList, "TABLE " + table6.getName(), table6.getCreateSQL());
                }
                String[] stringArray = sessionLocal.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StringBuilder stringBuilder = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        StringUtils.quoteIdentifier(stringBuilder, (String)stringArray[i]);
                    }
                    this.add(sessionLocal, arrayList, "SCHEMA_SEARCH_PATH", stringBuilder.toString());
                }
                if ((string15 = sessionLocal.getCurrentSchemaName()) != null) {
                    this.add(sessionLocal, arrayList, "SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), string15).toString());
                }
                if ((timeZoneProvider = sessionLocal.currentTimeZone()).equals(DateTimeUtils.getTimeZone())) break;
                this.add(sessionLocal, arrayList, "TIME ZONE", StringUtils.quoteStringSQL(new StringBuilder("SET TIME ZONE "), timeZoneProvider.getId()).toString());
                break;
            }
            case 28: {
                QueryStatisticsData queryStatisticsData = this.database.getQueryStatisticsData();
                if (queryStatisticsData == null) break;
                for (QueryStatisticsData.QueryEntry queryEntry : queryStatisticsData.getQueries()) {
                    this.add(sessionLocal, arrayList, queryEntry.sqlStatement, ValueInteger.get(queryEntry.count), ValueDouble.get((double)queryEntry.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)queryEntry.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)queryEntry.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(queryEntry.executionTimeMeanNanos / 1000000.0), ValueDouble.get(queryEntry.getExecutionTimeStandardDeviation() / 1000000.0), ValueBigint.get(queryEntry.rowCountMin), ValueBigint.get(queryEntry.rowCountMax), ValueBigint.get(queryEntry.rowCountCumulative), ValueDouble.get(queryEntry.rowCountMean), ValueDouble.get(queryEntry.getRowCountStandardDeviation()));
                }
                break;
            }
            case 29: {
                for (TableSynonym tableSynonym : this.database.getAllSynonyms()) {
                    this.add(sessionLocal, arrayList, string3, tableSynonym.getSchema().getName(), tableSynonym.getName(), tableSynonym.getSynonymForName(), tableSynonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", InformationSchemaTableLegacy.replaceNullWithEmpty(tableSynonym.getComment()), ValueInteger.get(tableSynonym.getId()));
                }
                break;
            }
            case 30: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() != Constraint.Type.DOMAIN && this.checkIndex(sessionLocal, constraint.getTable().getName(), value, value2)).forEach(constraint -> {
                    Constraint.Type type = constraint.getConstraintType();
                    Table table = constraint.getTable();
                    this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), type.getSqlName(), string3, table.getSchema().getName(), table.getName(), "NO", "NO", InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                });
                break;
            }
            case 31: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    if (((Constraint)schemaObject).getConstraintType() != Constraint.Type.DOMAIN) continue;
                    ConstraintDomain constraintDomain = (ConstraintDomain)schemaObject;
                    Domain domain = constraintDomain.getDomain();
                    this.add(sessionLocal, arrayList, string3, constraintDomain.getSchema().getName(), constraintDomain.getName(), string3, domain.getSchema().getName(), domain.getName(), "NO", "NO", InformationSchemaTableLegacy.replaceNullWithEmpty(constraintDomain.getComment()), constraintDomain.getCreateSQL(), ValueInteger.get(constraintDomain.getId()));
                }
                break;
            }
            case 32: {
                this.getAllConstraints(sessionLocal).forEach(constraint -> {
                    IndexColumn[] indexColumnArray;
                    Constraint.Type type = constraint.getConstraintType();
                    if (type.isUnique()) {
                        indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (type == Constraint.Type.REFERENTIAL) {
                        indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    } else {
                        return;
                    }
                    Table table = constraint.getTable();
                    String string2 = table.getName();
                    if (!this.checkIndex(sessionLocal, string2, value, value2)) {
                        return;
                    }
                    ConstraintUnique constraintUnique = type == Constraint.Type.REFERENTIAL ? constraint.getReferencedConstraint() : null;
                    Index index = constraint.getIndex();
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        IndexColumn indexColumn = indexColumnArray[i];
                        ValueInteger valueInteger = ValueInteger.get(i + 1);
                        ValueInteger valueInteger2 = null;
                        if (constraintUnique != null) {
                            Column column = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                            IndexColumn[] indexColumnArray2 = constraintUnique.getColumns();
                            for (int j = 0; j < indexColumnArray2.length; ++j) {
                                if (!indexColumnArray2[j].column.equals(column)) continue;
                                valueInteger2 = ValueInteger.get(j + 1);
                                break;
                            }
                        }
                        this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), string3, table.getSchema().getName(), string2, indexColumn.columnName, valueInteger, valueInteger2, index != null ? string3 : null, index != null ? index.getSchema().getName() : null, index != null ? index.getName() : null);
                    }
                });
                break;
            }
            case 33: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() == Constraint.Type.REFERENTIAL && this.checkIndex(sessionLocal, constraint.getName(), value, value2)).forEach(constraint -> {
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    ConstraintUnique constraintUnique = constraintReferential.getReferencedConstraint();
                    this.add(sessionLocal, arrayList, string3, constraintReferential.getSchema().getName(), constraintReferential.getName(), string3, constraintUnique.getSchema().getName(), constraintUnique.getName(), "NONE", constraintReferential.getUpdateAction().getSqlName(), constraintReferential.getDeleteAction().getSqlName());
                });
                break;
            }
            case 34: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType().isCheck() && this.checkIndex(sessionLocal, constraint.getName(), value, value2)).forEach(constraint -> this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), constraint.getExpression().getSQL(0, 2)));
                break;
            }
            case 35: {
                this.getAllConstraints(sessionLocal).forEach(constraint -> {
                    switch (constraint.getConstraintType()) {
                        case CHECK: 
                        case DOMAIN: {
                            HashSet<Column> hashSet = new HashSet<Column>();
                            constraint.getExpression().isEverything(ExpressionVisitor.getColumnsVisitor(hashSet, null));
                            for (Column column : hashSet) {
                                Table table = column.getTable();
                                if (!this.checkIndex(sessionLocal, table.getName(), value, value2)) continue;
                                this.addConstraintColumnUsage(sessionLocal, arrayList, string3, (Constraint)constraint, column);
                            }
                            break;
                        }
                        case REFERENTIAL: {
                            Table table = constraint.getRefTable();
                            if (this.checkIndex(sessionLocal, table.getName(), value, value2)) {
                                for (Column column : constraint.getReferencedColumns(table)) {
                                    this.addConstraintColumnUsage(sessionLocal, arrayList, string3, (Constraint)constraint, column);
                                }
                            }
                        }
                        case PRIMARY_KEY: 
                        case UNIQUE: {
                            Table table = constraint.getTable();
                            if (!this.checkIndex(sessionLocal, table.getName(), value, value2)) break;
                            for (Column column : constraint.getReferencedColumns(table)) {
                                this.addConstraintColumnUsage(sessionLocal, arrayList, string3, (Constraint)constraint, column);
                            }
                            break;
                        }
                    }
                });
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private static short getRefAction(ConstraintActionType constraintActionType) {
        switch (constraintActionType) {
            case NO_ACTION: {
                return 3;
            }
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.getInternalError("action=" + constraintActionType);
    }

    private void addConstraintColumnUsage(SessionLocal sessionLocal, ArrayList<Row> arrayList, String string, Constraint constraint, Column column) {
        Table table = column.getTable();
        this.add(sessionLocal, arrayList, string, table.getSchema().getName(), table.getName(), column.getName(), string, constraint.getSchema().getName(), constraint.getName());
    }

    private void addPrivileges(SessionLocal sessionLocal, ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(SessionLocal sessionLocal, ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(sessionLocal, arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string3, string4);
        } else {
            this.add(sessionLocal, arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string2, string3, string4);
        }
    }

    private ArrayList<SchemaObject> getAllSchemaObjects(int n) {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        for (Schema schema : this.database.getAllSchemas()) {
            schema.getAll(n, arrayList);
        }
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 8: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }
}

