/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.table;

import bending.libraries.h2.engine.SessionLocal;
import bending.libraries.h2.index.Index;
import bending.libraries.h2.index.IndexType;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.result.Row;
import bending.libraries.h2.schema.Schema;
import bending.libraries.h2.table.IndexColumn;
import bending.libraries.h2.table.Table;
import bending.libraries.h2.table.TableType;
import bending.libraries.h2.util.ParserUtil;
import java.util.List;

public abstract class VirtualTable
extends Table {
    protected VirtualTable(Schema schema, int n, String string) {
        super(schema, n, string, false, true);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        return ParserUtil.quoteIdentifier(stringBuilder, this.getName(), n);
    }

    @Override
    public void close(SessionLocal sessionLocal) {
    }

    @Override
    public Index addIndex(SessionLocal sessionLocal, String string, int n, IndexColumn[] indexColumnArray, int n2, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public void removeRow(SessionLocal sessionLocal, Row row) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public long truncate(SessionLocal sessionLocal) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public void addRow(SessionLocal sessionLocal, Row row) {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("Virtual table");
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public List<Index> getIndexes() {
        return List.of();
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public boolean canDrop() {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("Virtual table");
    }
}

