/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.tools;

import bending.libraries.h2.message.DbException;
import bending.libraries.h2.mvstore.MVStore;
import bending.libraries.h2.mvstore.MVStoreTool;
import bending.libraries.h2.mvstore.db.ValueDataType;
import bending.libraries.h2.mvstore.tx.TransactionMap;
import bending.libraries.h2.mvstore.tx.TransactionStore;
import bending.libraries.h2.result.Row;
import bending.libraries.h2.store.FileLister;
import bending.libraries.h2.store.fs.FileUtils;
import bending.libraries.h2.tools.CompressTool;
import bending.libraries.h2.tools.CompressionType;
import bending.libraries.h2.tools.Recover;
import bending.libraries.h2.value.Value;
import bending.libraries.h2.value.ValueCollectionBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DirectRecover
extends Recover {
    private ExecutorService kanziExecutor = null;
    private CompressionType compressionType = CompressionType.NONE;
    private boolean debugMode = false;
    private boolean showProgress = true;

    public static void main(String ... stringArray) throws SQLException {
        new DirectRecover().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-trace".equals(string3)) {
                bl = true;
                this.debugMode = true;
                this.showProgress = false;
                continue;
            }
            if ("-compress".equals(string3)) {
                String string4 = stringArray[++i].toUpperCase();
                try {
                    this.compressionType = CompressionType.valueOf(string4);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLException("Invalid compression type: " + string4 + ". Valid options: none, gzip, zip, bzip2, kanzi");
                }
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string3);
        }
        this.trace = bl;
        if (this.compressionType != CompressionType.NONE && !this.isCompressionAvailable(this.compressionType)) {
            System.err.println("WARNING: " + this.compressionType + " compression library not found in classpath.");
            System.err.println("Falling back to uncompressed output (.sql files).");
            if (this.compressionType == CompressionType.BZIP2) {
                System.err.println("To enable BZIP2: Add commons-compress.jar to classpath");
                System.err.println("Download from: https://commons.apache.org/proper/commons-compress/");
            } else if (this.compressionType == CompressionType.KANZI) {
                System.err.println("To enable KANZI: Add kanzi.jar to classpath");
                System.err.println("Download from: https://github.com/flanglet/kanzi-java");
            }
            System.err.println();
        }
        this.debug("Starting DirectRecover with compression: " + this.compressionType);
        this.processWithPipe(string, string2);
        this.debug("DirectRecover completed successfully");
    }

    private void debug(String string) {
        if (this.debugMode) {
            System.out.println("[DEBUG] " + string + " [Thread: " + Thread.currentThread().getName() + "]");
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithPipe(String string, String string2) {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.isEmpty()) {
            this.printNoDatabaseFilesFound(string, string2);
            return;
        }
        this.debug("Found " + arrayList.size() + " database files to process");
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            for (String string3 : arrayList) {
                Object object;
                if (!string3.endsWith(".mv.db")) continue;
                this.debug("Processing file: " + string3);
                String string4 = string3.substring(0, string3.length() - ".mv.db".length());
                ProgressBar progressBar = null;
                if (this.showProgress) {
                    object = new File(string3).getName();
                    progressBar = new ProgressBar("Processing " + (String)object, 50);
                }
                object = null;
                PipedReader pipedReader = null;
                try {
                    this.debug("Creating pipes for: " + string3);
                    object = new PipedWriter();
                    pipedReader = new PipedReader((PipedWriter)object, 262144);
                    Object object2 = object;
                    PipedReader pipedReader2 = pipedReader;
                    ProgressBar progressBar2 = progressBar;
                    this.debug("Starting dump task for: " + string3);
                    CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.lambda$processWithPipe$0(string3, (PipedWriter)object2), executorService);
                    this.debug("Starting SQL task for: " + string3);
                    CompletableFuture<Void> completableFuture2 = CompletableFuture.runAsync(() -> {
                        this.debug("SQL TASK: Starting SQL conversion for " + string3);
                        try (PrintWriter printWriter = this.getCompressedWriter(string4 + ".h2.db");){
                            this.debug("SQL TASK: Created compressed writer, starting processPipedDumpToSQL");
                            this.processPipedDumpToSQL(pipedReader2, printWriter, string3, progressBar2);
                            this.debug("SQL TASK: processPipedDumpToSQL completed, flushing");
                            printWriter.flush();
                            this.debug("SQL TASK: Flush completed, SQL task finishing");
                        }
                        catch (Exception exception) {
                            this.debug("SQL TASK: Error - " + exception.getMessage());
                            this.trace("Error in SQL conversion task: " + exception.getMessage());
                        }
                        this.debug("SQL TASK: SQL task completed for " + string3);
                    }, executorService);
                    this.debug("Waiting for both tasks to complete for: " + string3);
                    try {
                        CompletableFuture.allOf(completableFuture, completableFuture2).get(1L, TimeUnit.DAYS);
                        this.debug("Both tasks completed successfully for: " + string3);
                        if (progressBar == null) continue;
                        progressBar.finish();
                    }
                    catch (TimeoutException timeoutException) {
                        this.debug("TIMEOUT: Processing timed out 1 day for: " + string3);
                        this.trace("Processing timed out after 1 day");
                        completableFuture.cancel(true);
                        completableFuture2.cancel(true);
                        if (progressBar == null) continue;
                        progressBar.finish();
                    }
                }
                catch (Exception exception) {
                    this.debug("ERROR: Exception processing " + string3 + ": " + exception.getMessage());
                    this.traceError("Error processing " + string3, exception);
                }
                finally {
                    this.debug("Cleaning up pipes for: " + string3);
                    if (object != null) {
                        try {
                            ((PipedWriter)object).close();
                            this.debug("PipeWriter closed for: " + string3);
                        }
                        catch (Exception exception) {
                            this.debug("Error closing PipeWriter: " + exception.getMessage());
                        }
                    }
                    if (pipedReader != null) {
                        try {
                            pipedReader.close();
                            this.debug("PipeReader closed for: " + string3);
                        }
                        catch (Exception exception) {
                            this.debug("Error closing PipeReader: " + exception.getMessage());
                        }
                    }
                    this.debug("Pipe cleanup completed for: " + string3);
                }
            }
        }
        finally {
            this.debug("Shutting down executor");
            executorService.shutdown();
            try {
                this.debug("Waiting for executor termination (30 seconds)");
                if (!executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.debug("Executor did not terminate gracefully, forcing shutdown");
                    this.trace("Executor did not terminate gracefully, forcing shutdown");
                    executorService.shutdownNow();
                    if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                        this.debug("Executor did not terminate after force shutdown");
                        System.err.println("Executor did not terminate");
                    } else {
                        this.debug("Executor terminated after force shutdown");
                    }
                } else {
                    this.debug("Executor terminated gracefully");
                }
            }
            catch (InterruptedException interruptedException) {
                this.debug("Interrupted while waiting for executor termination");
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.debug("Executor shutdown completed");
        }
    }

    private PrintWriter getCompressedWriter(String string) {
        string = string.substring(0, string.length() - 3);
        switch (this.compressionType) {
            case GZIP: {
                String string2 = string + ".sql.gz";
                this.debug("Creating GZIP compressed writer for: " + string2);
                try {
                    OutputStream outputStream = FileUtils.newOutputStream(string2, false);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
                    this.debug("GZIP writer created successfully: " + string2);
                    this.trace("Created compressed file: " + string2);
                    return new PrintWriter(new OutputStreamWriter((OutputStream)gZIPOutputStream, StandardCharsets.UTF_8));
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, null);
                }
            }
            case ZIP: {
                String string3 = string + ".sql.zip";
                this.debug("Creating ZIP compressed writer for: " + string3);
                try {
                    OutputStream outputStream = FileUtils.newOutputStream(string3, false);
                    final ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                    String string4 = new File(string + ".sql").getName();
                    zipOutputStream.putNextEntry(new ZipEntry(string4));
                    this.debug("ZIP writer created successfully: " + string3);
                    this.trace("Created compressed file: " + string3);
                    return new PrintWriter(new OutputStreamWriter((OutputStream)zipOutputStream, StandardCharsets.UTF_8)){

                        @Override
                        public void close() {
                            try {
                                super.close();
                                zipOutputStream.closeEntry();
                                zipOutputStream.close();
                                DirectRecover.this.debug("ZIP writer closed successfully.");
                            }
                            catch (IOException iOException) {
                                DirectRecover.this.debug("Error closing ZIP stream: " + iOException.getMessage());
                                System.err.println("Error closing ZIP stream: " + iOException.getMessage());
                            }
                        }
                    };
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, null);
                }
            }
            case BZIP2: {
                String string5 = string + ".sql.bz2";
                this.debug("Creating BZIP2 compressed writer for: " + string5);
                try {
                    OutputStream outputStream = FileUtils.newOutputStream(string5, false);
                    OutputStream outputStream2 = this.createCompressedStream(CompressionType.BZIP2, outputStream);
                    this.debug("BZIP2 writer created successfully: " + string5);
                    this.trace("Created compressed file: " + string5);
                    return new PrintWriter(new OutputStreamWriter(outputStream2, StandardCharsets.UTF_8));
                }
                catch (Exception exception) {
                    this.debug("BZIP2 compression not available, falling back: " + exception.getMessage());
                    this.trace("BZip2 compression not available: " + exception.getMessage());
                    this.trace("Falling back to uncompressed output");
                    string5 = string + ".sql";
                    this.debug("Creating fallback uncompressed writer for: " + string5);
                    this.trace("Created fallback file: " + string5);
                    try {
                        OutputStream outputStream = FileUtils.newOutputStream(string5, false);
                        return new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                    }
                    catch (IOException iOException) {
                        throw DbException.convertIOException(iOException, null);
                    }
                }
            }
            case KANZI: {
                String string6 = string + ".sql.knz";
                this.debug("Creating KANZI compressed writer for: " + string6);
                try {
                    this.debug("KANZI: Opening output stream for: " + string6);
                    OutputStream outputStream = FileUtils.newOutputStream(string6, false);
                    this.debug("KANZI: Base output stream created successfully");
                    this.debug("KANZI: Creating compressed stream...");
                    final OutputStream outputStream3 = this.createCompressedStream(CompressionType.KANZI, outputStream);
                    this.debug("KANZI: Compressed stream created successfully");
                    this.debug("KANZI writer created successfully: " + string6);
                    this.trace("Created compressed file: " + string6);
                    return new PrintWriter(new OutputStreamWriter(outputStream3, StandardCharsets.UTF_8)){

                        @Override
                        public void close() {
                            try {
                                DirectRecover.this.debug("KANZI: Closing PrintWriter");
                                super.close();
                                DirectRecover.this.debug("KANZI: Closing compressed stream");
                                if (DirectRecover.this.kanziExecutor != null) {
                                    DirectRecover.this.kanziExecutor.shutdown();
                                    DirectRecover.this.kanziExecutor.awaitTermination(1L, TimeUnit.DAYS);
                                }
                                outputStream3.close();
                                DirectRecover.this.debug("KANZI writer closed successfully.");
                            }
                            catch (IOException | InterruptedException exception) {
                                DirectRecover.this.debug("Error closing KANZI stream: " + exception.getMessage());
                                System.err.println("Error closing Kanzi stream: " + exception.getMessage());
                                exception.printStackTrace();
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    this.debug("KANZI compression FAILED, falling back: " + exception.getMessage());
                    System.err.println("KANZI compression failed: " + exception.getMessage());
                    exception.printStackTrace();
                    this.trace("Kanzi compression not available: " + exception.getMessage());
                    this.trace("Falling back to uncompressed output");
                    string6 = string + ".sql";
                    this.debug("Creating fallback uncompressed writer for: " + string6);
                    this.trace("Created fallback file: " + string6);
                    try {
                        OutputStream outputStream = FileUtils.newOutputStream(string6, false);
                        return new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                    }
                    catch (IOException iOException) {
                        throw DbException.convertIOException(iOException, null);
                    }
                }
            }
        }
        String string7 = string + ".sql";
        this.debug("Creating uncompressed writer for: " + string7);
        this.trace("Created file: " + string7);
        return this.getWriter(string, ".sql");
    }

    private OutputStream createCompressedStream(CompressionType compressionType, OutputStream outputStream) throws Exception {
        switch (compressionType) {
            case BZIP2: {
                return CompressTool.createBZip2OutputStream(outputStream);
            }
            case KANZI: {
                int n = Runtime.getRuntime().availableProcessors();
                this.kanziExecutor = Executors.newFixedThreadPool(n);
                return CompressTool.createKanziOutputStream(outputStream, this.kanziExecutor);
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPipedDumpToSQL(PipedReader pipedReader, PrintWriter printWriter, String string, ProgressBar progressBar) {
        BufferedReader bufferedReader = null;
        try {
            this.debug("PROCESS: Starting processPipedDumpToSQL for " + string);
            bufferedReader = new BufferedReader(pipedReader);
            this.debug("PROCESS: Writing SQL header");
            printWriter.println("-- MVStore");
            String string2 = Recover.class.getName();
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_MAP FOR '" + string2 + ".readBlobMap';");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_MAP FOR '" + string2 + ".readClobMap';");
            this.debug("PROCESS: Resetting schema");
            this.resetSchema();
            this.setDatabaseName(string.substring(0, string.length() - ".mv.db".length()));
            this.debug("PROCESS: Starting background SQL generation");
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                this.debug("SQL_GEN: Starting background generateSQLFromMVStore");
                this.generateSQLFromMVStore(printWriter, string);
                this.debug("SQL_GEN: Background generateSQLFromMVStore completed");
            }, executorService);
            this.debug("PROCESS: Starting parallel dump consumption");
            int n = 0;
            long l = 1000000L;
            while (bufferedReader.readLine() != null) {
                if (this.debugMode && ++n % 10000 == 0) {
                    this.debug("PROCESS: Consumed " + n + " dump lines");
                }
                if (progressBar != null && n % 1000 == 0) {
                    long l2 = Math.min((long)n, l);
                    progressBar.update(l2, l);
                }
                if (n % 1000 != 0) continue;
                Thread.yield();
            }
            this.debug("PROCESS: Consumed and discarded total of " + n + " dump lines");
            this.debug("PROCESS: Waiting for SQL generation to complete");
            completableFuture.get(1L, TimeUnit.DAYS);
            this.debug("PROCESS: SQL generation completed");
            if (progressBar != null) {
                progressBar.update(l, l);
            }
            executorService.shutdown();
        }
        catch (Exception exception) {
            this.debug("PROCESS: Error in processPipedDumpToSQL: " + exception.getMessage());
            this.writeError(printWriter, exception);
        }
        finally {
            this.debug("PROCESS: Cleaning up BufferedReader");
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    this.debug("PROCESS: BufferedReader closed");
                }
                catch (Exception exception) {
                    this.debug("PROCESS: Error closing BufferedReader: " + exception.getMessage());
                }
            }
            this.debug("PROCESS: processPipedDumpToSQL completed for " + string);
        }
    }

    private void generateSQLFromMVStore(PrintWriter printWriter, String string) {
        this.debug("GENERATE: Starting generateSQLFromMVStore for " + string);
        try (MVStore mVStore = new MVStore.Builder().fileName(string).recoveryMode().readOnly().open();){
            Row row;
            Iterator<Object> iterator;
            TransactionMap transactionMap;
            String string2;
            this.debug("GENERATE: MVStore opened, dumping LOB maps");
            this.dumpLobMaps(printWriter, mVStore);
            printWriter.println("-- Layout");
            this.debug("GENERATE: Dumping layout");
            DirectRecover.dumpLayout(printWriter, mVStore);
            printWriter.println("-- Meta");
            this.debug("GENERATE: Dumping meta");
            DirectRecover.dumpMeta(printWriter, mVStore);
            printWriter.println("-- Types");
            this.debug("GENERATE: Dumping types");
            DirectRecover.dumpTypes(printWriter, mVStore);
            printWriter.println("-- Tables");
            this.debug("GENERATE: Creating transaction store");
            TransactionStore transactionStore = new TransactionStore(mVStore, new ValueDataType());
            try {
                transactionStore.init();
                this.debug("GENERATE: Transaction store initialized");
            }
            catch (Throwable throwable) {
                this.debug("GENERATE: Error initializing transaction store: " + throwable.getMessage());
                this.writeError(printWriter, throwable);
            }
            this.debug("GENERATE: Extracting metadata");
            for (String string3 : mVStore.getMapNames()) {
                if (!string3.startsWith("table.") || Integer.parseInt(string2 = string3.substring("table.".length())) != 0) continue;
                transactionMap = transactionStore.begin().openMap(string3);
                iterator = transactionMap.keyIterator(null);
                while (iterator.hasNext()) {
                    Long l = iterator.next();
                    row = (Row)transactionMap.get(l);
                    try {
                        this.writeMetaRow(row);
                    }
                    catch (Throwable throwable) {
                        this.writeError(printWriter, throwable);
                    }
                }
            }
            this.debug("GENERATE: Writing schema SET");
            this.writeSchemaSET(printWriter);
            printWriter.println("---- Table Data ----");
            this.debug("GENERATE: Processing table data");
            for (String string3 : mVStore.getMapNames()) {
                if (!string3.startsWith("table.") || Integer.parseInt(string2 = string3.substring("table.".length())) == 0) continue;
                transactionMap = transactionStore.begin().openMap(string3);
                iterator = transactionMap.keyIterator(null);
                boolean bl = false;
                while (iterator.hasNext()) {
                    String string4;
                    int n;
                    StringBuilder stringBuilder;
                    Value[] valueArray;
                    row = iterator.next();
                    Object v = transactionMap.get(row);
                    if (v instanceof Row) {
                        valueArray = ((Row)v).getValueList();
                        this.recordLength = valueArray.length;
                    } else {
                        valueArray = ((ValueCollectionBase)v).getList();
                        this.recordLength = valueArray.length - 1;
                    }
                    if (!bl) {
                        this.setStorage(Integer.parseInt(string2));
                        stringBuilder = new StringBuilder();
                        for (n = 0; n < this.recordLength; ++n) {
                            string4 = this.storageName + "." + n;
                            stringBuilder.setLength(0);
                            this.getSQL(stringBuilder, string4, valueArray[n]);
                        }
                        this.createTemporaryTable(printWriter);
                        bl = true;
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("INSERT INTO O_").append(string2).append(" VALUES(");
                    for (n = 0; n < this.recordLength; ++n) {
                        if (n > 0) {
                            stringBuilder.append(", ");
                        }
                        string4 = this.storageName + "." + n;
                        this.getSQL(stringBuilder, string4, valueArray[n]);
                    }
                    stringBuilder.append(");");
                    printWriter.println(stringBuilder);
                }
            }
            this.debug("GENERATE: Writing schema");
            this.writeSchema(printWriter);
            printWriter.println("DROP ALIAS READ_BLOB_MAP;");
            printWriter.println("DROP ALIAS READ_CLOB_MAP;");
            printWriter.println("DROP TABLE IF EXISTS INFORMATION_SCHEMA.LOB_BLOCKS;");
            this.debug("GENERATE: generateSQLFromMVStore completed successfully");
        }
        catch (Throwable throwable) {
            this.debug("GENERATE: Error in generateSQLFromMVStore: " + throwable.getMessage());
            this.writeError(printWriter, throwable);
        }
    }

    public boolean isCompressionAvailable(CompressionType compressionType) {
        switch (compressionType) {
            case BZIP2: {
                try {
                    Class.forName("org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream");
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }
            case KANZI: {
                try {
                    Class.forName("io.github.flanglet.kanzi.io.CompressedOutputStream");
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }
            case GZIP: 
            case ZIP: 
            case NONE: {
                return true;
            }
        }
        return false;
    }

    public CompressionType[] getAvailableCompressionTypes() {
        ArrayList<CompressionType> arrayList = new ArrayList<CompressionType>();
        for (CompressionType compressionType : CompressionType.values()) {
            if (!this.isCompressionAvailable(compressionType)) continue;
            arrayList.add(compressionType);
        }
        return arrayList.toArray(new CompressionType[0]);
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public static void execute(String string, String string2, PrintWriter printWriter) throws SQLException {
        try {
            DirectRecover directRecover = new DirectRecover();
            directRecover.processWithPipe(string, string2);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private /* synthetic */ void lambda$processWithPipe$0(String string, PipedWriter pipedWriter) {
        this.debug("DUMP TASK: Starting dump for " + string);
        try (PrintWriter printWriter = new PrintWriter(pipedWriter);){
            this.debug("DUMP TASK: Created writer, starting MVStoreTool.dump");
            MVStoreTool.dump(string, printWriter, true);
            this.debug("DUMP TASK: MVStoreTool.dump completed, starting info");
            MVStoreTool.info(string, printWriter);
            this.debug("DUMP TASK: MVStoreTool.info completed, flushing");
            printWriter.flush();
            this.debug("DUMP TASK: Flush completed, dump task finishing");
        }
        catch (Exception exception) {
            this.debug("DUMP TASK: Error - " + exception.getMessage());
            this.trace("Error in dump task: " + exception.getMessage());
        }
        this.debug("DUMP TASK: Dump task completed for " + string);
    }

    private static class ProgressBar {
        private final int width;
        private final String prefix;
        private long lastUpdate = 0L;
        private int lastProgress = -1;

        public ProgressBar(String string, int n) {
            this.prefix = string;
            this.width = n;
        }

        public void update(long l, long l2) {
            int n;
            long l3 = System.currentTimeMillis();
            if (l3 - this.lastUpdate < 100L) {
                return;
            }
            this.lastUpdate = l3;
            int n2 = n = l2 > 0L ? (int)(l * 100L / l2) : 0;
            if (n == this.lastProgress) {
                return;
            }
            this.lastProgress = n;
            int n3 = n * this.width / 100;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\r').append(this.prefix).append(" [");
            for (int i = 0; i < this.width; ++i) {
                if (i < n3) {
                    stringBuilder.append('\u2588');
                    continue;
                }
                if (i == n3 && n < 100) {
                    stringBuilder.append('\u2593');
                    continue;
                }
                stringBuilder.append('\u2591');
            }
            stringBuilder.append(String.format("] %3d%% ", n));
            System.out.print(stringBuilder);
            System.out.flush();
            if (n >= 100) {
                System.out.println();
            }
        }

        public void finish() {
            if (this.lastProgress < 100) {
                System.out.println();
            }
        }
    }
}

