/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.tools;

import java.io.IOException;
import java.io.InputStream;

public class ZeroBytesEOFInputStream
extends InputStream {
    private final InputStream wrapped;
    private int consecutiveZeroReads = 0;
    private static final int MAX_ZERO_READS = 10;
    private boolean eofReached = false;

    public ZeroBytesEOFInputStream(InputStream inputStream) {
        this.wrapped = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.eofReached) {
            return -1;
        }
        while (this.consecutiveZeroReads < 10) {
            int n = this.wrapped.read();
            if (n == -1) {
                this.eofReached = true;
                return -1;
            }
            if (n >= 0) {
                this.consecutiveZeroReads = 0;
                return n;
            }
            ++this.consecutiveZeroReads;
        }
        this.eofReached = true;
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eofReached) {
            return -1;
        }
        while (this.consecutiveZeroReads < 10) {
            int n3 = this.wrapped.read(byArray, n, n2);
            if (n3 == -1) {
                this.eofReached = true;
                return -1;
            }
            if (n3 > 0) {
                this.consecutiveZeroReads = 0;
                return n3;
            }
            ++this.consecutiveZeroReads;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while reading compressed stream", interruptedException);
            }
        }
        this.eofReached = true;
        return -1;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.wrapped.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.wrapped.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapped.reset();
        this.consecutiveZeroReads = 0;
        this.eofReached = false;
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }
}

