/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.h2.value;

import bending.libraries.h2.engine.CastDataProvider;
import bending.libraries.h2.engine.SysProperties;
import bending.libraries.h2.message.DbException;
import bending.libraries.h2.store.DataHandler;
import bending.libraries.h2.store.FileStore;
import bending.libraries.h2.store.FileStoreOutputStream;
import bending.libraries.h2.store.LobStorageInterface;
import bending.libraries.h2.util.IOUtils;
import bending.libraries.h2.util.MathUtils;
import bending.libraries.h2.util.StringUtils;
import bending.libraries.h2.util.Utils;
import bending.libraries.h2.value.CompareMode;
import bending.libraries.h2.value.Value;
import bending.libraries.h2.value.ValueLob;
import bending.libraries.h2.value.lob.LobData;
import bending.libraries.h2.value.lob.LobDataDatabase;
import bending.libraries.h2.value.lob.LobDataFetchOnDemand;
import bending.libraries.h2.value.lob.LobDataFile;
import bending.libraries.h2.value.lob.LobDataInMemory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ValueBlob
extends ValueLob {
    public static ValueBlob createSmall(byte[] byArray) {
        return new ValueBlob(new LobDataInMemory(byArray), byArray.length);
    }

    public static ValueBlob createTempBlob(InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n;
            long l2 = Long.MAX_VALUE;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob.getBufferSize(dataHandler, l2)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n = byArray.length;
            } else {
                byArray = Utils.newBytes(n);
                n = IOUtils.readFully(inputStream, byArray, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                return ValueBlob.createSmall(Utils.copyBytes(byArray, n));
            }
            return ValueBlob.createTemporary(dataHandler, byArray, n, inputStream, l2);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static ValueBlob createTemporary(DataHandler dataHandler, byte[] byArray, int n, InputStream inputStream, long l) throws IOException {
        String string = ValueLob.createTempLobFileName(dataHandler);
        FileStore fileStore = dataHandler.openFile(string, "rw", false);
        fileStore.autoDelete();
        long l2 = 0L;
        try (FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(fileStore, null);){
            do {
                l2 += (long)n;
                fileStoreOutputStream.write(byArray, 0, n);
                if ((l -= (long)n) <= 0L) {
                    break;
                }
                n = ValueLob.getBufferSize(dataHandler, l);
            } while ((n = IOUtils.readFully(inputStream, byArray, n)) > 0);
        }
        return new ValueBlob(new LobDataFile(dataHandler, string, fileStore), l2);
    }

    public ValueBlob(LobData lobData, long l) {
        super(lobData, l, -1L);
    }

    @Override
    public int getValueType() {
        return 7;
    }

    @Override
    public String getString() {
        long l = this.charLength;
        if (l >= 0L) {
            if (l > 1000000000L) {
                throw this.getStringTooLong(l);
            }
            return this.readString((int)l);
        }
        if (this.octetLength > 3000000000L) {
            throw this.getStringTooLong(this.charLength());
        }
        String string = this.lobData instanceof LobDataInMemory ? new String(((LobDataInMemory)this.lobData).getSmall(), StandardCharsets.UTF_8) : this.readString(Integer.MAX_VALUE);
        this.charLength = l = (long)string.length();
        if (l > 1000000000L) {
            throw this.getStringTooLong(l);
        }
        return string;
    }

    @Override
    byte[] getBytesInternal() {
        if (this.octetLength > 1000000000L) {
            throw this.getBinaryTooLong(this.octetLength);
        }
        return this.readBytes((int)this.octetLength);
    }

    @Override
    public InputStream getInputStream() {
        return this.lobData.getInputStream(this.octetLength);
    }

    @Override
    public InputStream getInputStream(long l, long l2) {
        long l3 = this.octetLength;
        return ValueBlob.rangeInputStream(this.lobData.getInputStream(l3), l, l2, l3);
    }

    @Override
    public Reader getReader(long l, long l2) {
        return ValueBlob.rangeReader(this.getReader(), l, l2, -1L);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        if (value == this) {
            return 0;
        }
        ValueBlob valueBlob = (ValueBlob)value;
        LobData lobData = this.lobData;
        LobData lobData2 = valueBlob.lobData;
        if (lobData.getClass() == lobData2.getClass()) {
            if (lobData instanceof LobDataInMemory) {
                return Integer.signum(Arrays.compareUnsigned(((LobDataInMemory)lobData).getSmall(), ((LobDataInMemory)lobData2).getSmall()));
            }
            if (lobData instanceof LobDataDatabase ? ((LobDataDatabase)lobData).getLobId() == ((LobDataDatabase)lobData2).getLobId() : lobData instanceof LobDataFetchOnDemand && ((LobDataFetchOnDemand)lobData).getLobId() == ((LobDataFetchOnDemand)lobData2).getLobId()) {
                return 0;
            }
        }
        return ValueBlob.compare(this, valueBlob);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int compare(ValueBlob valueBlob, ValueBlob valueBlob2) {
        try (InputStream inputStream = valueBlob.getInputStream();
             InputStream inputStream2 = valueBlob2.getInputStream();){
            int n;
            int n2;
            byte[] byArray = new byte[512];
            byte[] byArray2 = new byte[512];
            for (long i = Math.min(valueBlob.octetLength, valueBlob2.octetLength); i >= 512L; i -= 512L) {
                if (IOUtils.readFully(inputStream, byArray, 512) != 512) throw DbException.getUnsupportedException("Invalid LOB");
                if (IOUtils.readFully(inputStream2, byArray2, 512) != 512) {
                    throw DbException.getUnsupportedException("Invalid LOB");
                }
                n2 = Integer.signum(Arrays.compareUnsigned(byArray, byArray2));
                if (n2 == 0) continue;
                int n3 = n2;
                return n3;
            }
            do {
                n2 = inputStream.read();
                n = inputStream2.read();
                if (n2 < 0) {
                    int n4 = n < 0 ? 0 : -1;
                    return n4;
                }
                if (n >= 0) continue;
                int n5 = 1;
                return n5;
            } while (n2 == n);
            int n6 = (n2 & 0xFF) < (n & 0xFF) ? -1 : 1;
            return n6;
        }
        catch (IOException iOException) {
            throw DbException.convert(iOException);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        if (!((n & 2) == 0 || this.lobData instanceof LobDataInMemory && this.octetLength <= SysProperties.MAX_TRACE_DATA_LENGTH)) {
            stringBuilder.append("CAST(REPEAT(CHAR(0), ").append(this.octetLength).append(") AS BINARY VARYING");
            this.formatLobDataComment(stringBuilder);
        } else if ((n & 6) == 0) {
            stringBuilder.append("CAST(X'");
            StringUtils.convertBytesToHex(stringBuilder, this.getBytesNoCopy()).append("' AS BINARY LARGE OBJECT(").append(this.octetLength).append("))");
        } else {
            stringBuilder.append("X'");
            StringUtils.convertBytesToHex(stringBuilder, this.getBytesNoCopy()).append('\'');
        }
        return stringBuilder;
    }

    ValueBlob convertPrecision(long l) {
        ValueBlob valueBlob;
        if (this.octetLength <= l) {
            return this;
        }
        DataHandler dataHandler = this.lobData.getDataHandler();
        if (dataHandler != null) {
            valueBlob = ValueBlob.createTempBlob(this.getInputStream(), l, dataHandler);
        } else {
            try {
                valueBlob = ValueBlob.createSmall(IOUtils.readBytesAndClose(this.getInputStream(), MathUtils.convertLongToInt(l)));
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
        return valueBlob;
    }

    @Override
    public ValueLob copy(DataHandler dataHandler, int n) {
        if (this.lobData instanceof LobDataInMemory) {
            byte[] byArray = ((LobDataInMemory)this.lobData).getSmall();
            if (byArray.length > dataHandler.getMaxLengthInplaceLob()) {
                LobStorageInterface lobStorageInterface = dataHandler.getLobStorage();
                ValueBlob valueBlob = lobStorageInterface.createBlob(this.getInputStream(), this.octetLength);
                ValueLob valueLob = valueBlob.copy(dataHandler, n);
                valueBlob.remove();
                return valueLob;
            }
            return this;
        }
        if (this.lobData instanceof LobDataDatabase) {
            return dataHandler.getLobStorage().copyLob(this, n);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long charLength() {
        long l = this.charLength;
        if (l < 0L) {
            if (this.lobData instanceof LobDataInMemory) {
                l = new String(((LobDataInMemory)this.lobData).getSmall(), StandardCharsets.UTF_8).length();
            } else {
                try (Reader reader = this.getReader();){
                    l = 0L;
                    while (true) {
                        l += reader.skip(Long.MAX_VALUE);
                        if (reader.read() < 0) {
                            break;
                        }
                        ++l;
                    }
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, null);
                }
            }
            this.charLength = l;
        }
        return l;
    }

    @Override
    public long octetLength() {
        return this.octetLength;
    }
}

