/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jackson.databind.ext;

import bending.libraries.jackson.core.JsonGenerator;
import bending.libraries.jackson.core.JsonToken;
import bending.libraries.jackson.core.type.WritableTypeId;
import bending.libraries.jackson.databind.SerializerProvider;
import bending.libraries.jackson.databind.jsontype.TypeSerializer;
import bending.libraries.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.nio.file.Path;

public class NioPathSerializer
extends StdScalarSerializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathSerializer() {
        super(Path.class);
    }

    @Override
    public void serialize(Path value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(value.toUri().toString());
    }

    @Override
    public void serializeWithType(Path value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, Path.class, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }
}

