/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jackson.databind.ser.std;

import bending.libraries.jackson.core.JsonGenerator;
import bending.libraries.jackson.databind.JavaType;
import bending.libraries.jackson.databind.JsonMappingException;
import bending.libraries.jackson.databind.SerializerProvider;
import bending.libraries.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import bending.libraries.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import bending.libraries.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import bending.libraries.jackson.databind.ser.std.StdScalarSerializer;
import bending.libraries.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

