/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jackson.databind.ser.std;

import bending.libraries.jackson.core.JsonGenerator;
import bending.libraries.jackson.core.JsonToken;
import bending.libraries.jackson.core.type.WritableTypeId;
import bending.libraries.jackson.databind.JavaType;
import bending.libraries.jackson.databind.JsonMappingException;
import bending.libraries.jackson.databind.JsonNode;
import bending.libraries.jackson.databind.SerializerProvider;
import bending.libraries.jackson.databind.annotation.JacksonStdImpl;
import bending.libraries.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import bending.libraries.jackson.databind.jsontype.TypeSerializer;
import bending.libraries.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    public ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

