/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.argument;

import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.argument.ArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.BoxedArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.CharSequenceArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.DirectArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.EnumArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.EssentialsArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.InternetArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.JavaTimeArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.JavaTimeZoneIdArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.NVarcharArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.NullArgument;
import bending.libraries.jdbi.v3.core.argument.OptionalArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.PrimitivesArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.QualifiedArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.SqlArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.SqlTimeArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.UntypedNullArgumentFactory;
import bending.libraries.jdbi.v3.core.array.SqlArrayArgumentFactory;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.config.JdbiConfig;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import bending.libraries.jdbi.v3.meta.Beta;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class Arguments
implements JdbiConfig<Arguments> {
    private final List<QualifiedArgumentFactory> factories;
    private final Map<QualifiedType<?>, Function<Object, Argument>> preparedFactories = new ConcurrentHashMap();
    private final Set<QualifiedType<?>> didPrepare = ConcurrentHashMap.newKeySet();
    private ConfigRegistry registry;
    private Argument untypedNullArgument = new NullArgument(1111);
    private boolean bindingNullToPrimitivesPermitted = true;
    private boolean preparedArgumentsEnabled = true;

    public Arguments(ConfigRegistry registry) {
        this.factories = new CopyOnWriteArrayList<QualifiedArgumentFactory>();
        this.registry = registry;
        this.register(new UntypedNullArgumentFactory());
        this.register(new PrimitivesArgumentFactory());
        this.register(new BoxedArgumentFactory());
        this.register(new SqlArgumentFactory());
        this.register(new InternetArgumentFactory());
        this.register(new SqlTimeArgumentFactory());
        this.register(new JavaTimeArgumentFactory());
        this.register(new SqlArrayArgumentFactory());
        this.register(new CharSequenceArgumentFactory());
        this.register(new EssentialsArgumentFactory());
        this.register(new JavaTimeZoneIdArgumentFactory());
        this.register(new NVarcharArgumentFactory());
        this.register(new EnumArgumentFactory());
        this.register(new OptionalArgumentFactory());
        this.register(new DirectArgumentFactory());
    }

    private Arguments(Arguments that) {
        this.factories = new CopyOnWriteArrayList<QualifiedArgumentFactory>(that.factories);
        this.untypedNullArgument = that.untypedNullArgument;
        this.bindingNullToPrimitivesPermitted = that.bindingNullToPrimitivesPermitted;
        this.preparedArgumentsEnabled = that.preparedArgumentsEnabled;
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public Arguments register(ArgumentFactory factory) {
        return this.register(QualifiedArgumentFactory.adapt(this.registry, factory));
    }

    public Arguments register(QualifiedArgumentFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<Argument> findFor(Type type, Object value) {
        return this.findFor(QualifiedType.of(type), value);
    }

    public Optional<Argument> findFor(QualifiedType<?> type, Object value) {
        Function<Object, Argument> prepared = this.preparedFactories.get(type);
        if (prepared != null) {
            return Optional.of(prepared.apply(value));
        }
        for (QualifiedArgumentFactory factory : this.factories) {
            Optional<Argument> maybeBuilt = factory.build(type, value, this.registry);
            if (!maybeBuilt.isPresent()) continue;
            if (factory instanceof QualifiedArgumentFactory.Preparable && this.didPrepare.add(type)) {
                ((QualifiedArgumentFactory.Preparable)factory).prepare(type, this.registry).ifPresent(argumentFactory -> this.preparedFactories.putIfAbsent(type, (Function<Object, Argument>)argumentFactory));
            }
            return maybeBuilt;
        }
        return Optional.empty();
    }

    public Optional<Function<Object, Argument>> prepareFor(Type type) {
        return this.prepareFor(QualifiedType.of(type));
    }

    @Beta
    public Optional<Function<Object, Argument>> prepareFor(QualifiedType<?> type) {
        if (!this.isPreparedArgumentsEnabled()) {
            return Optional.empty();
        }
        Function<Object, Argument> prepared = this.preparedFactories.get(type);
        if (prepared != null) {
            return Optional.of(prepared);
        }
        for (QualifiedArgumentFactory factory : this.factories) {
            Optional<Function<Object, Argument>> argumentFactory;
            if (!(factory instanceof QualifiedArgumentFactory.Preparable) || !(argumentFactory = ((QualifiedArgumentFactory.Preparable)factory).prepare(type, this.registry)).isPresent()) continue;
            this.preparedFactories.putIfAbsent(type, argumentFactory.get());
            return argumentFactory;
        }
        return Optional.empty();
    }

    public List<QualifiedArgumentFactory> getFactories() {
        return Collections.unmodifiableList(this.factories);
    }

    public void setUntypedNullArgument(Argument untypedNullArgument) {
        if (untypedNullArgument == null) {
            throw new IllegalArgumentException("the Argument itself may not be null");
        }
        this.untypedNullArgument = untypedNullArgument;
    }

    public Argument getUntypedNullArgument() {
        return this.untypedNullArgument;
    }

    public boolean isBindingNullToPrimitivesPermitted() {
        return this.bindingNullToPrimitivesPermitted;
    }

    public void setBindingNullToPrimitivesPermitted(boolean bindingNullToPrimitivesPermitted) {
        this.bindingNullToPrimitivesPermitted = bindingNullToPrimitivesPermitted;
    }

    public boolean isPreparedArgumentsEnabled() {
        return this.preparedArgumentsEnabled;
    }

    public void setPreparedArgumentsEnabled(boolean preparedArgumentsEnabled) {
        this.preparedArgumentsEnabled = preparedArgumentsEnabled;
    }

    @Override
    public Arguments createCopy() {
        return new Arguments(this);
    }
}

