/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.argument;

import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.argument.ArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.ObjectArgument;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ObjectArgumentFactory
implements ArgumentFactory.Preparable {
    private final Class<?> type;
    private final Integer sqlType;

    public static ArgumentFactory create(Class<?> type) {
        return ObjectArgumentFactory.create(type, null);
    }

    public static ArgumentFactory create(Class<?> type, Integer sqlType) {
        return new ObjectArgumentFactory(type, sqlType);
    }

    private ObjectArgumentFactory(Class<?> type, Integer sqlType) {
        this.type = type;
        this.sqlType = sqlType;
    }

    @Override
    public Optional<Function<Object, Argument>> prepare(Type expectedType, ConfigRegistry config) {
        return Optional.of(expectedType).filter(this.type::equals).map(t -> o -> ObjectArgument.of(o, this.sqlType));
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        return Objects.equals(this.type, expectedType) || this.type.isInstance(value) ? Optional.of(ObjectArgument.of(value, this.sqlType)) : Optional.empty();
    }
}

