/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.argument;

import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.argument.Arguments;
import bending.libraries.jdbi.v3.core.argument.DelegatingArgumentFactory;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;

class OptionalArgumentFactory
extends DelegatingArgumentFactory {
    OptionalArgumentFactory() {
        this.register(OptionalInt.class, 4, (p, i, v) -> {
            if (v.isPresent()) {
                p.setInt(i, v.getAsInt());
            } else {
                p.setNull(i, 4);
            }
        });
        this.register(OptionalLong.class, -5, (p, i, v) -> {
            if (v.isPresent()) {
                p.setLong(i, v.getAsLong());
            } else {
                p.setNull(i, -5);
            }
        });
        this.register(OptionalDouble.class, 8, (p, i, v) -> {
            if (v.isPresent()) {
                p.setDouble(i, v.getAsDouble());
            } else {
                p.setNull(i, 8);
            }
        });
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        if (value instanceof Optional) {
            Object nestedValue = ((Optional)value).orElse(null);
            Type nestedType = OptionalArgumentFactory.findOptionalType(expectedType, nestedValue);
            return config.get(Arguments.class).findFor(nestedType, nestedValue);
        }
        return super.build(expectedType, value, config);
    }

    @Override
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        if (Optional.class.equals(GenericTypes.getErasedType(type))) {
            return config.get(Arguments.class).prepareFor(OptionalArgumentFactory.findOptionalType(type, null)).map(af -> opt -> (Argument)af.apply(((Optional)opt).orElse(null)));
        }
        return super.prepare(type, config);
    }

    private static Type findOptionalType(Type wrapperType, Object nestedValue) {
        Optional<Type> nestedType;
        if (GenericTypes.getErasedType(wrapperType).equals(Optional.class) && (nestedType = GenericTypes.findGenericParameter(wrapperType, Optional.class)).isPresent()) {
            return nestedType.get();
        }
        return nestedValue == null ? Object.class : nestedValue.getClass();
    }
}

