/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.argument;

import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.argument.ArgumentFactory;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import bending.libraries.jdbi.v3.core.qualifier.Qualifiers;
import bending.libraries.jdbi.v3.meta.Beta;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@FunctionalInterface
public interface QualifiedArgumentFactory {
    public Optional<Argument> build(QualifiedType<?> var1, Object var2, ConfigRegistry var3);

    public static QualifiedArgumentFactory adapt(ConfigRegistry config, ArgumentFactory factory) {
        if (factory instanceof ArgumentFactory.Preparable) {
            return QualifiedArgumentFactory.adapt(config, (ArgumentFactory.Preparable)factory);
        }
        Set<Annotation> qualifiers = config.get(Qualifiers.class).findFor(factory.getClass());
        return (type, value, cfg) -> type.getQualifiers().equals(qualifiers) ? factory.build(type.getType(), value, cfg) : Optional.empty();
    }

    public static Preparable adapt(ConfigRegistry config, ArgumentFactory.Preparable factory) {
        return Preparable.adapt(config, factory);
    }

    @Beta
    public static interface Preparable
    extends QualifiedArgumentFactory {
        public Optional<Function<Object, Argument>> prepare(QualifiedType<?> var1, ConfigRegistry var2);

        @Deprecated(since="3.15.0", forRemoval=true)
        default public Collection<QualifiedType<?>> prePreparedTypes() {
            return Collections.emptyList();
        }

        public static Preparable adapt(final ConfigRegistry config, final ArgumentFactory.Preparable factory) {
            return new Preparable(){
                final Set<Annotation> qualifiers;
                final Collection<QualifiedType<?>> prePreparedTypes;
                {
                    this.qualifiers = config.get(Qualifiers.class).findFor(factory.getClass());
                    this.prePreparedTypes = Collections.unmodifiableList(factory.prePreparedTypes().stream().map(QualifiedType::of).map(qt -> qt.withAnnotations(this.qualifiers)).collect(Collectors.toList()));
                }

                @Override
                public Optional<Argument> build(QualifiedType<?> type, Object value, ConfigRegistry cfg) {
                    return type.getQualifiers().equals(this.qualifiers) ? factory.build(type.getType(), value, cfg) : Optional.empty();
                }

                @Override
                public Optional<Function<Object, Argument>> prepare(QualifiedType<?> type, ConfigRegistry cfg) {
                    return type.getQualifiers().equals(this.qualifiers) ? factory.prepare(type.getType(), cfg) : Optional.empty();
                }

                @Override
                @Deprecated(since="3.39.0", forRemoval=true)
                public Collection<QualifiedType<?>> prePreparedTypes() {
                    return this.prePreparedTypes;
                }

                public String toString() {
                    return "Qualified[" + String.valueOf(factory) + "]";
                }
            };
        }
    }
}

