/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.array;

import bending.libraries.jdbi.v3.core.array.ArrayColumnMapper;
import bending.libraries.jdbi.v3.core.array.CollectorColumnMapper;
import bending.libraries.jdbi.v3.core.collector.JdbiCollectors;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.ColumnMappers;
import java.lang.reflect.Type;
import java.util.Optional;

public class SqlArrayMapperFactory
implements ColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> erasedType = GenericTypes.getErasedType(type);
        if (erasedType.isArray()) {
            Class<?> elementType = erasedType.getComponentType();
            return this.elementTypeMapper(elementType, config).map(elementMapper -> new ArrayColumnMapper((ColumnMapper<?>)elementMapper, elementType));
        }
        JdbiCollectors collectorRegistry = config.get(JdbiCollectors.class);
        return collectorRegistry.findFor(type).flatMap(collector -> collectorRegistry.findElementTypeFor(type).flatMap(elementType -> this.elementTypeMapper((Type)elementType, config)).map(elementMapper -> new CollectorColumnMapper(elementMapper, collector)));
    }

    private Optional<ColumnMapper<?>> elementTypeMapper(Type elementType, ConfigRegistry config) {
        Optional<ColumnMapper<?>> mapper = config.get(ColumnMappers.class).findFor(elementType);
        if (!mapper.isPresent() && elementType == Object.class) {
            return Optional.of((rs, num, context) -> rs.getObject(num));
        }
        return mapper;
    }
}

