/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.config;

import bending.libraries.jdbi.v3.core.argument.Arguments;
import bending.libraries.jdbi.v3.core.collector.JdbiCollectors;
import bending.libraries.jdbi.v3.core.config.JdbiConfig;
import bending.libraries.jdbi.v3.core.config.internal.ConfigCaches;
import bending.libraries.jdbi.v3.core.internal.JdbiClassUtils;
import bending.libraries.jdbi.v3.core.mapper.ColumnMappers;
import bending.libraries.jdbi.v3.core.mapper.Mappers;
import bending.libraries.jdbi.v3.core.mapper.RowMappers;
import bending.libraries.jdbi.v3.core.statement.SqlStatements;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class ConfigRegistry {
    private static final Class<?>[] JDBI_CONFIG_TYPES = new Class[]{ConfigRegistry.class};
    private final Map<Class<? extends JdbiConfig<?>>, JdbiConfig<?>> configs = new ConcurrentHashMap(32);
    private final Map<Class<? extends JdbiConfig<?>>, Function<ConfigRegistry, JdbiConfig<?>>> configFactories;

    public ConfigRegistry() {
        this.configFactories = new ConcurrentHashMap();
        this.get(ConfigCaches.class);
        this.get(SqlStatements.class);
        this.get(Arguments.class);
        this.get(RowMappers.class);
        this.get(ColumnMappers.class);
        this.get(Mappers.class);
        this.get(JdbiCollectors.class);
    }

    private ConfigRegistry(ConfigRegistry that) {
        this.configFactories = that.configFactories;
        that.configs.forEach((type, config) -> {
            Object copy = config.createCopy();
            this.configs.put((Class<JdbiConfig<?>>)type, (JdbiConfig<?>)copy);
        });
        this.configs.values().forEach(c -> c.setRegistry(this));
    }

    public <C extends JdbiConfig<C>> C get(Class<C> configClass) {
        JdbiConfig<?> lookup = this.configs.get(configClass);
        if (lookup != null) {
            return (C)((JdbiConfig)configClass.cast(lookup));
        }
        JdbiConfig config = (JdbiConfig)configClass.cast(this.configFactory(configClass).apply(this));
        return (C)Optional.ofNullable((JdbiConfig)configClass.cast(this.configs.putIfAbsent(configClass, config))).orElse(config);
    }

    private Function<ConfigRegistry, JdbiConfig<?>> configFactory(Class<? extends JdbiConfig<?>> configClass) {
        return this.configFactories.computeIfAbsent(configClass, klass -> {
            JdbiClassUtils.MethodHandleHolder handleHolder = JdbiClassUtils.findConstructor(klass, JDBI_CONFIG_TYPES);
            return registry -> {
                JdbiConfig config = (JdbiConfig)handleHolder.invoke(handle -> handle.invokeExact((ConfigRegistry)registry));
                config.setRegistry((ConfigRegistry)registry);
                return config;
            };
        });
    }

    public ConfigRegistry createCopy() {
        return new ConfigRegistry(this);
    }
}

