/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.enums.internal;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.enums.EnumStrategy;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.internal.EnumStrategies;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.EnumMapper;
import bending.libraries.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import java.util.Optional;

public class EnumMapperFactory
implements QualifiedColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(QualifiedType<?> givenType, ConfigRegistry config) {
        return Optional.of(givenType.getType()).map(GenericTypes::getErasedType).filter(Enum.class::isAssignableFrom).map(clazz -> EnumMapperFactory.makeEnumArgument(givenType, clazz, config));
    }

    private static <E extends Enum<E>> ColumnMapper<?> makeEnumArgument(QualifiedType<E> givenType, Class<E> enumClass, ConfigRegistry config) {
        boolean byName = EnumStrategy.BY_NAME == config.get(EnumStrategies.class).findStrategy(givenType);
        return byName ? EnumMapper.byName(enumClass) : EnumMapper.byOrdinal(enumClass);
    }
}

