/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.extension;

import bending.libraries.jdbi.v3.core.extension.ExtensionHandler;
import bending.libraries.jdbi.v3.core.extension.ExtensionHandlerFactory;
import bending.libraries.jdbi.v3.core.extension.UnableToCreateExtensionException;
import java.lang.reflect.Method;
import java.util.Optional;

final class DefaultMethodExtensionHandlerFactory
implements ExtensionHandlerFactory {
    static final ExtensionHandlerFactory INSTANCE = new DefaultMethodExtensionHandlerFactory();

    DefaultMethodExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return extensionType.isInterface() && method.isDefault();
    }

    @Override
    public Optional<ExtensionHandler> createExtensionHandler(Class<?> extensionType, Method method) {
        try {
            return Optional.of(ExtensionHandler.createForSpecialMethod(method));
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateExtensionException(e, "Default method handler for %s couldn't unreflect %s", extensionType, method);
        }
    }
}

