/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.extension;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.extension.AttachedExtensionHandler;
import bending.libraries.jdbi.v3.core.extension.HandleSupplier;
import bending.libraries.jdbi.v3.core.internal.exceptions.Sneaky;
import bending.libraries.jdbi.v3.meta.Alpha;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;

@FunctionalInterface
@Alpha
public interface ExtensionHandler {
    public AttachedExtensionHandler attachTo(ConfigRegistry var1, Object var2);

    public static ExtensionHandler missingExtensionHandler(Method method) {
        return (handleSupplier, args) -> {
            throw new IllegalStateException(String.format("Method %s.%s has no registered extension handler!", method.getDeclaringClass().getSimpleName(), method.getName()));
        };
    }

    public static ExtensionHandler createForMethod(Method method) throws IllegalAccessException {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandle methodHandle = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup()).unreflect(method);
        return ExtensionHandler.createForMethodHandle(methodHandle);
    }

    public static ExtensionHandler createForSpecialMethod(Method method) throws IllegalAccessException {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandle methodHandle = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup()).unreflectSpecial(method, declaringClass);
        return ExtensionHandler.createForMethodHandle(methodHandle);
    }

    public static ExtensionHandler createForMethodHandle(final MethodHandle methodHandle) {
        return new ExtensionHandler(){

            @Override
            public AttachedExtensionHandler attachTo(ConfigRegistry config, final Object target) {
                if (target == null) {
                    throw new IllegalStateException("no target object present, called from a proxy factory?");
                }
                return new AttachedExtensionHandler(){
                    final MethodHandle boundMh;
                    {
                        this.boundMh = methodHandle.bindTo(target);
                    }

                    @Override
                    public Object invoke(HandleSupplier handleSupplier, Object ... args) throws Exception {
                        try {
                            return this.boundMh.invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            throw Sneaky.throwAnyway(e);
                        }
                    }
                };
            }
        };
    }

    @FunctionalInterface
    public static interface Simple
    extends ExtensionHandler,
    AttachedExtensionHandler {
        @Override
        default public AttachedExtensionHandler attachTo(ConfigRegistry config, Object target) {
            return this;
        }
    }
}

