/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.extension;

import bending.libraries.jdbi.v3.core.extension.ExtensionHandler;
import bending.libraries.jdbi.v3.core.extension.ExtensionHandlerFactory;
import bending.libraries.jdbi.v3.core.extension.UnableToCreateExtensionException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

final class InstanceExtensionHandlerFactory
implements ExtensionHandlerFactory {
    static final ExtensionHandlerFactory INSTANCE = new InstanceExtensionHandlerFactory();

    InstanceExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return Modifier.isAbstract(method.getModifiers()) || !extensionType.isInterface() && method.getDeclaringClass() != Object.class;
    }

    @Override
    public Optional<ExtensionHandler> createExtensionHandler(Class<?> extensionType, Method method) {
        try {
            return Optional.of(ExtensionHandler.createForMethod(method));
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateExtensionException(e, "Instance handler for %s couldn't unreflect %s", extensionType, method);
        }
    }
}

