/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.extension;

import bending.libraries.jdbi.v3.core.config.ConfigCustomizer;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.extension.ConfigCustomizerFactory;
import bending.libraries.jdbi.v3.core.extension.ExtensionConfigurer;
import bending.libraries.jdbi.v3.core.extension.annotation.UseExtensionConfigurer;
import bending.libraries.jdbi.v3.core.internal.JdbiClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class UseAnnotationConfigCustomizerFactory
implements ConfigCustomizerFactory {
    private static final Class<?>[] EXTENSION_CONFIGURER_TYPES = new Class[]{Annotation.class, Class.class, Method.class};
    static final ConfigCustomizerFactory INSTANCE = new UseAnnotationConfigCustomizerFactory();

    UseAnnotationConfigCustomizerFactory() {
    }

    @Override
    public Collection<ConfigCustomizer> forExtensionType(Class<?> extensionType) {
        ConfigurerMethod forType = (configurer, config, annotation) -> configurer.configureForType(config, annotation, extensionType);
        return UseAnnotationConfigCustomizerFactory.buildConfigCustomizer(extensionType, null, Stream.concat(JdbiClassUtils.superTypes(extensionType), Stream.of(extensionType)), forType);
    }

    @Override
    public Collection<ConfigCustomizer> forExtensionMethod(Class<?> extensionType, Method method) {
        ConfigurerMethod forMethod = (configurer, config, annotation) -> configurer.configureForMethod(config, annotation, extensionType, method);
        return UseAnnotationConfigCustomizerFactory.buildConfigCustomizer(extensionType, method, Stream.of(method), forMethod);
    }

    private static Collection<ConfigCustomizer> buildConfigCustomizer(Class<?> extensionType, Method method, Stream<AnnotatedElement> elements, ConfigurerMethod consumer) {
        return elements.flatMap(ae -> Arrays.stream(ae.getAnnotations())).filter(a -> a.annotationType().isAnnotationPresent(UseExtensionConfigurer.class)).map(a -> {
            UseExtensionConfigurer meta = a.annotationType().getAnnotation(UseExtensionConfigurer.class);
            Class<? extends ExtensionConfigurer> klass = meta.value();
            ExtensionConfigurer configurer = JdbiClassUtils.findConstructorAndCreateInstance(klass, EXTENSION_CONFIGURER_TYPES, handle -> handle.invokeExact((Annotation)a, extensionType, method));
            return config -> consumer.configure(configurer, config, (Annotation)a);
        }).collect(Collectors.toList());
    }

    @FunctionalInterface
    private static interface ConfigurerMethod {
        public void configure(ExtensionConfigurer var1, ConfigRegistry var2, Annotation var3);
    }
}

