/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.extension;

import bending.libraries.jdbi.v3.core.extension.ExtensionHandler;
import bending.libraries.jdbi.v3.core.extension.ExtensionHandlerFactory;
import bending.libraries.jdbi.v3.core.extension.annotation.UseExtensionHandler;
import bending.libraries.jdbi.v3.core.internal.JdbiClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class UseAnnotationExtensionHandlerFactory
implements ExtensionHandlerFactory {
    private static final Class<?>[] EXTENSION_HANDLER_TYPES = new Class[]{Class.class, Method.class};
    static final ExtensionHandlerFactory INSTANCE = new UseAnnotationExtensionHandlerFactory();

    UseAnnotationExtensionHandlerFactory() {
    }

    @Override
    public boolean accepts(Class<?> extensionType, Method method) {
        return !method.isBridge() && !UseAnnotationExtensionHandlerFactory.findAnnotations(method).isEmpty();
    }

    private static boolean matchAnnotation(Annotation a) {
        return a.annotationType().isAnnotationPresent(UseExtensionHandler.class);
    }

    static List<Class<?>> findAnnotations(Method method) {
        return Stream.of(method.getAnnotations()).filter(UseAnnotationExtensionHandlerFactory::matchAnnotation).map(Annotation::annotationType).collect(Collectors.toList());
    }

    @Override
    public Optional<ExtensionHandler> createExtensionHandler(Class<?> extensionType, Method method) {
        List<Class<?>> extensionAnnotations = UseAnnotationExtensionHandlerFactory.findAnnotations(method);
        if (extensionAnnotations.size() > 1) {
            throw new IllegalStateException(String.format("Mutually exclusive extension annotations on method %s.%s: %s", extensionType.getName(), method.getName(), extensionAnnotations));
        }
        if (method.isDefault() && !method.isSynthetic()) {
            throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. Extension type methods may be default, or have a @UseExtensionHandler annotation, but not both.", extensionType.getSimpleName(), method.getName(), extensionAnnotations.get(0).getSimpleName()));
        }
        return extensionAnnotations.stream().map(type -> type.getAnnotation(UseExtensionHandler.class)).map(UseExtensionHandler::value).map(klass -> (ExtensionHandler)JdbiClassUtils.findConstructorAndCreateInstance(klass, EXTENSION_HANDLER_TYPES, handle -> handle.invokeExact(extensionType, method))).findFirst();
    }
}

