/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.internal;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.config.JdbiConfig;
import bending.libraries.jdbi.v3.core.enums.EnumByName;
import bending.libraries.jdbi.v3.core.enums.EnumByOrdinal;
import bending.libraries.jdbi.v3.core.enums.EnumStrategy;
import bending.libraries.jdbi.v3.core.enums.Enums;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.internal.JdbiOptionals;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import bending.libraries.jdbi.v3.core.qualifier.Qualifiers;
import java.util.Optional;

public class EnumStrategies
implements JdbiConfig<EnumStrategies> {
    private ConfigRegistry registry;

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public <E extends Enum<E>> EnumStrategy findStrategy(QualifiedType<E> type) {
        Class<?> erasedType = GenericTypes.getErasedType(type.getType());
        return JdbiOptionals.findFirstPresent(() -> EnumStrategies.doFindStrategy(type), () -> EnumStrategies.doFindStrategy(QualifiedType.of(erasedType).withAnnotations(this.registry.get(Qualifiers.class).findFor(erasedType)))).orElseGet(() -> this.registry.get(Enums.class).getDefaultStrategy());
    }

    private static <T> Optional<EnumStrategy> doFindStrategy(QualifiedType<T> type) {
        boolean hasByName = type.hasQualifier(EnumByName.class);
        boolean hasByOrdinal = type.hasQualifier(EnumByOrdinal.class);
        if (hasByName && hasByOrdinal) {
            throw new IllegalArgumentException(String.format("%s is both %s and %s", type.getType(), EnumByName.class.getSimpleName(), EnumByOrdinal.class.getSimpleName()));
        }
        if (hasByName) {
            return Optional.of(EnumStrategy.BY_NAME);
        }
        if (hasByOrdinal) {
            return Optional.of(EnumStrategy.BY_ORDINAL);
        }
        return Optional.empty();
    }

    @Override
    public EnumStrategies createCopy() {
        return new EnumStrategies();
    }
}

