/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.GetterMapper;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Optional;

class BoxedMapperFactory
implements ColumnMapperFactory {
    private final IdentityHashMap<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    BoxedMapperFactory() {
        this.mappers.put(Boolean.class, new GetterMapper<Boolean>(ResultSet::getBoolean));
        this.mappers.put(Byte.class, new GetterMapper<Byte>(ResultSet::getByte));
        this.mappers.put(Character.class, new GetterMapper<Character>(BoxedMapperFactory::getCharacter));
        this.mappers.put(Short.class, new GetterMapper<Short>(ResultSet::getShort));
        this.mappers.put(Integer.class, new GetterMapper<Integer>(ResultSet::getInt));
        this.mappers.put(Long.class, new GetterMapper<Long>(ResultSet::getLong));
        this.mappers.put(Float.class, new GetterMapper<Float>(ResultSet::getFloat));
        this.mappers.put(Double.class, new GetterMapper<Double>(ResultSet::getDouble));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(rawType));
    }

    private static Character getCharacter(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        return s == null || s.isEmpty() ? null : Character.valueOf(s.charAt(0));
    }
}

