/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.ColumnMappers;
import bending.libraries.jdbi.v3.core.mapper.MapEntryMappers;
import bending.libraries.jdbi.v3.core.mapper.NoSuchMapperException;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.mapper.RowMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.RowMappers;
import bending.libraries.jdbi.v3.core.mapper.SingleColumnMapper;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;

public class MapEntryMapper<K, V>
implements RowMapper<Map.Entry<K, V>> {
    private static final TypeVariable<Class<Map.Entry>> KEY_PARAM;
    private static final TypeVariable<Class<Map.Entry>> VALUE_PARAM;
    private final RowMapper<K> keyMapper;
    private final RowMapper<V> valueMapper;

    static RowMapperFactory factory() {
        return (type, config) -> {
            if (type instanceof ParameterizedType && GenericTypes.getErasedType(type).equals(Map.Entry.class)) {
                Type keyType = GenericTypes.resolveType(KEY_PARAM, type);
                Type valueType = GenericTypes.resolveType(VALUE_PARAM, type);
                RowMapper<?> keyMapper = MapEntryMapper.getKeyMapper(keyType, config);
                RowMapper<?> valueMapper = MapEntryMapper.getValueMapper(valueType, config);
                return Optional.of(new MapEntryMapper(keyMapper, valueMapper));
            }
            return Optional.empty();
        };
    }

    private static RowMapper<?> getKeyMapper(Type keyType, ConfigRegistry config) {
        String column = config.get(MapEntryMappers.class).getKeyColumn();
        if (column == null) {
            return config.get(RowMappers.class).findFor(keyType).orElseThrow(() -> new NoSuchMapperException(String.format("Map key column is not declared (missing @KeyColumn annotation?) and no row mapper for key type '%s' is registered!", keyType)));
        }
        return config.get(ColumnMappers.class).findFor(keyType).map(mapper -> new SingleColumnMapper(mapper, column)).orElseThrow(() -> new NoSuchMapperException(String.format("Type '%s' for map key column '%s' has no column mapper registered!", keyType, column)));
    }

    private static RowMapper<?> getValueMapper(Type valueType, ConfigRegistry config) {
        String column = config.get(MapEntryMappers.class).getValueColumn();
        if (column == null) {
            return config.get(RowMappers.class).findFor(valueType).orElseThrow(() -> new NoSuchMapperException(String.format("Map value column is not declared (missing @ValueColumn annotation?) and no row mapper for value type '%s' is registered!", valueType)));
        }
        return config.get(ColumnMappers.class).findFor(valueType).map(mapper -> new SingleColumnMapper(mapper, column)).orElseThrow(() -> new NoSuchMapperException(String.format("Type '%s' for map value column '%s' has no column mapper registered!", valueType, column)));
    }

    private MapEntryMapper(RowMapper<K> keyMapper, RowMapper<V> valueMapper) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    public Map.Entry<K, V> map(ResultSet rs, StatementContext ctx) throws SQLException {
        return new AbstractMap.SimpleImmutableEntry<K, V>(this.keyMapper.map(rs, ctx), this.valueMapper.map(rs, ctx));
    }

    @Override
    public RowMapper<Map.Entry<K, V>> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        return new MapEntryMapper<K, V>(this.keyMapper.specialize(rs, ctx), this.valueMapper.specialize(rs, ctx));
    }

    static {
        TypeVariable<Class<T>>[] mapParams = Map.Entry.class.getTypeParameters();
        KEY_PARAM = mapParams[0];
        VALUE_PARAM = mapParams[1];
    }
}

