/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.ColumnGetter;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.ColumnMappers;
import bending.libraries.jdbi.v3.core.mapper.GetterMapper;
import bending.libraries.jdbi.v3.core.mapper.NoSuchMapperException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class OptionalColumnMapperFactory
implements ColumnMapperFactory {
    private static final Map<Class<?>, BiFunction<Type, ConfigRegistry, ColumnMapper<?>>> STRATEGIES;

    OptionalColumnMapperFactory() {
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        return Optional.ofNullable(STRATEGIES.get(GenericTypes.getErasedType(type))).map(strategy -> (ColumnMapper)strategy.apply(type, config));
    }

    static BiFunction<Type, ConfigRegistry, ColumnMapper<?>> singleton(ColumnMapper<?> instance) {
        return (t, c) -> instance;
    }

    static <Opt, Box> ColumnMapper<?> create(ColumnGetter<Box> columnGetter, Supplier<Opt> empty, Function<Box, Opt> present) {
        return (r, columnNumber, ctx) -> Optional.ofNullable(new GetterMapper(columnGetter).map(r, columnNumber, ctx)).map(present).orElseGet(empty);
    }

    private static ColumnMapper<?> create(Type type, ConfigRegistry config) {
        ColumnMapper<?> mapper = config.get(ColumnMappers.class).findFor(GenericTypes.findGenericParameter(type, Optional.class).orElseThrow(() -> new NoSuchMapperException("No mapper for raw Optional type"))).orElseThrow(() -> new NoSuchMapperException("No column mapper for type " + String.valueOf(type) + ", nested in Optional"));
        return (r, i, ctx) -> Optional.ofNullable(mapper.map(r, i, ctx));
    }

    static {
        HashMap s = new HashMap();
        s.put(Optional.class, OptionalColumnMapperFactory::create);
        s.put(OptionalInt.class, OptionalColumnMapperFactory.singleton(OptionalColumnMapperFactory.create(ResultSet::getInt, OptionalInt::empty, OptionalInt::of)));
        s.put(OptionalLong.class, OptionalColumnMapperFactory.singleton(OptionalColumnMapperFactory.create(ResultSet::getLong, OptionalLong::empty, OptionalLong::of)));
        s.put(OptionalDouble.class, OptionalColumnMapperFactory.singleton(OptionalColumnMapperFactory.create(ResultSet::getDouble, OptionalDouble::empty, OptionalDouble::of)));
        STRATEGIES = Collections.unmodifiableMap(s);
    }
}

