/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.config.JdbiConfig;
import bending.libraries.jdbi.v3.core.generic.GenericType;
import bending.libraries.jdbi.v3.core.interceptor.JdbiInterceptionChainHolder;
import bending.libraries.jdbi.v3.core.internal.CopyOnWriteHashMap;
import bending.libraries.jdbi.v3.core.mapper.InferredRowMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.MapEntryMapper;
import bending.libraries.jdbi.v3.core.mapper.OptionalRowMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.mapper.RowMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.reflect.internal.PojoMapperFactory;
import bending.libraries.jdbi.v3.meta.Alpha;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class RowMappers
implements JdbiConfig<RowMappers> {
    private final JdbiInterceptionChainHolder<RowMapper<?>, RowMapperFactory> inferenceInterceptors;
    private final List<RowMapperFactory> factories;
    private final Map<Type, Optional<RowMapper<?>>> cache;
    private ConfigRegistry registry;

    public RowMappers() {
        this.inferenceInterceptors = new JdbiInterceptionChainHolder<RowMapper, RowMapperFactory>(InferredRowMapperFactory::new);
        this.factories = new CopyOnWriteArrayList<RowMapperFactory>();
        this.cache = new CopyOnWriteHashMap();
        this.register(MapEntryMapper.factory());
        this.register(new PojoMapperFactory());
        this.register(new OptionalRowMapperFactory());
    }

    private RowMappers(RowMappers that) {
        this.factories = new CopyOnWriteArrayList<RowMapperFactory>(that.factories);
        this.cache = new CopyOnWriteHashMap(that.cache);
        this.inferenceInterceptors = new JdbiInterceptionChainHolder(that.inferenceInterceptors);
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    @Alpha
    public JdbiInterceptionChainHolder<RowMapper<?>, RowMapperFactory> getInferenceInterceptors() {
        return this.inferenceInterceptors;
    }

    public RowMappers register(RowMapper<?> mapper) {
        RowMapperFactory factory = this.inferenceInterceptors.process(mapper);
        return this.register(factory);
    }

    public <T> RowMappers register(GenericType<T> type, RowMapper<T> mapper) {
        return this.register(RowMapperFactory.of(type.getType(), mapper));
    }

    public RowMappers register(Type type, RowMapper<?> mapper) {
        return this.register(RowMapperFactory.of(type, mapper));
    }

    public RowMappers register(RowMapperFactory factory) {
        this.factories.add(0, factory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<RowMapper<T>> findFor(Class<T> type) {
        RowMapper mapper = this.findFor((Type)type).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public <T> Optional<RowMapper<T>> findFor(GenericType<T> type) {
        RowMapper mapper = this.findFor(type.getType()).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public Optional<RowMapper<?>> findFor(Type type) {
        Optional<RowMapper<?>> cached = this.cache.get(type);
        if (cached != null) {
            return cached;
        }
        for (RowMapperFactory factory : this.factories) {
            Optional<RowMapper<?>> maybeMapper = factory.build(type, this.registry);
            RowMapper mapper = maybeMapper.orElse(null);
            if (mapper == null) continue;
            mapper.init(this.registry);
            this.cache.put(type, maybeMapper);
            return maybeMapper;
        }
        this.cache.put(type, Optional.empty());
        return Optional.empty();
    }

    @Override
    public RowMappers createCopy() {
        return new RowMappers(this);
    }
}

