/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.GetterMapper;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.IdentityHashMap;
import java.util.Optional;

class SqlTimeMapperFactory
implements ColumnMapperFactory {
    private final IdentityHashMap<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    SqlTimeMapperFactory() {
        this.mappers.put(Timestamp.class, new GetterMapper<Timestamp>(ResultSet::getTimestamp));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(rawType));
    }
}

