/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper.reflect;

import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.Nested;
import bending.libraries.jdbi.v3.core.mapper.PropagateNull;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.mapper.RowMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.SingleColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.reflect.ColumnName;
import bending.libraries.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import bending.libraries.jdbi.v3.core.mapper.reflect.ConstructorInstanceFactory;
import bending.libraries.jdbi.v3.core.mapper.reflect.InstanceFactory;
import bending.libraries.jdbi.v3.core.mapper.reflect.JdbiConstructors;
import bending.libraries.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import bending.libraries.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import bending.libraries.jdbi.v3.core.mapper.reflect.internal.NullDelegatingMapper;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import bending.libraries.jdbi.v3.core.qualifier.Qualifiers;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class ConstructorMapper<T>
implements RowMapper<T> {
    private static final String DEFAULT_PREFIX = "";
    private static final String UNMATCHED_CONSTRUCTOR_PARAMETERS = "Instance factory '%s' could not match any parameter to any columns in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, annotate the parameter names explicitly with @ColumnName, or annotate nullable parameters as @Nullable";
    private static final String UNMATCHED_CONSTRUCTOR_PARAMETER = "Instance factory '%s' parameter '%s' has no matching columns in the result set. Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, annotate the parameter names explicitly with @ColumnName, or annotate nullable parameters as @Nullable";
    private final InstanceFactory<T> factory;
    private final String prefix;
    private final ConstructorProperties constructorProperties;
    private final Map<Parameter, ConstructorMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> clazz) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz));
    }

    public static RowMapperFactory factory(Class<?> clazz, String prefix) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, prefix));
    }

    public static RowMapperFactory factory(Class<?> clazz, Class<?> factoryMethodClass) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, factoryMethodClass));
    }

    public static RowMapperFactory factory(Class<?> clazz, Class<?> factoryMethodClass, String prefix) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, factoryMethodClass, prefix));
    }

    public static RowMapperFactory factory(Constructor<?> constructor) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor));
    }

    public static RowMapperFactory factory(Constructor<?> constructor, String prefix) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return ConstructorMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new ConstructorMapper<T>(JdbiConstructors.findFactoryFor(type), prefix);
    }

    public static <T> RowMapper<T> of(Class<T> type, Class<?> factoryMethodClass) {
        return ConstructorMapper.of(type, factoryMethodClass, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, Class<?> factoryMethodClass, String prefix) {
        return new ConstructorMapper<T>(JdbiConstructors.findFactoryFor(type, factoryMethodClass), prefix);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor) {
        return ConstructorMapper.of(constructor, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor, String prefix) {
        return new ConstructorMapper<T>(new ConstructorInstanceFactory<T>(constructor), prefix);
    }

    private ConstructorMapper(InstanceFactory<T> factory, String prefix) {
        this.factory = factory;
        this.prefix = prefix;
        this.constructorProperties = factory.getAnnotation(ConstructorProperties.class);
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        UnaryOperator<String> caseChange = ctx.getConfig(ReflectionMappers.class).getCaseChange();
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs, caseChange);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper mapper = this.createSpecializedRowMapper(ctx, columnNames, columnNameMatchers, unmatchedColumns, Function.identity()).orElseGet(() -> new UnmatchedConstructorMapper(String.format(UNMATCHED_CONSTRUCTOR_PARAMETERS, this.factory)));
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(unmatchedColumns, this.prefix, columnNameMatchers)) {
            return new UnmatchedConstructorMapper(String.format("Mapping instance factory %s could not match parameters for columns: %s", this.factory, unmatchedColumns));
        }
        return mapper;
    }

    private <R> Optional<RowMapper<R>> createSpecializedRowMapper(StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns, Function<T, R> postProcessor) {
        int count = this.factory.getParameterCount();
        Parameter[] parameters = this.factory.getParameters();
        List<Type> types = this.factory.getTypes();
        boolean matchedColumns = false;
        ArrayList<String> unmatchedParameters = new ArrayList<String>();
        ArrayList<ParameterData> paramData = new ArrayList<ParameterData>();
        for (int i = 0; i < count; ++i) {
            Optional<RowMapper<Object>> nestedMapper;
            Parameter parameter = parameters[i];
            Type parameterType = types.get(i);
            boolean nullable = this.isNullable(parameter);
            Nested nested = parameter.getAnnotation(Nested.class);
            if (nested == null) {
                String paramName = ReflectionMapperUtil.addPropertyNamePrefix(this.prefix, ConstructorMapper.paramName(parameters, i, this.constructorProperties));
                OptionalInt columnIndex = ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(parameter));
                if (columnIndex.isPresent()) {
                    int colIndex = columnIndex.getAsInt();
                    QualifiedType<?> type = QualifiedType.of(parameterType).withAnnotations(ctx.getConfig(Qualifiers.class).findFor(parameter));
                    paramData.add(new ParameterData(i, parameter, ctx.findColumnMapperFor(type).map(mapper -> new SingleColumnMapper(mapper, colIndex + 1)).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find column mapper for type '%s' of parameter '%s' for instance factory '%s'", type, paramName, this.factory)))));
                    matchedColumns = true;
                    unmatchedColumns.remove(columnNames.get(colIndex));
                    continue;
                }
                if (nullable) {
                    paramData.add(new ParameterData(i, parameter, null));
                    continue;
                }
                unmatchedParameters.add(paramName);
                continue;
            }
            String nestedPrefix = ReflectionMapperUtil.addPropertyNamePrefix(this.prefix, nested.value());
            if (parameter.getType().equals(Optional.class)) {
                Class rawType = GenericTypes.findGenericParameter(parameter.getParameterizedType(), Optional.class).map(GenericTypes::getErasedType).orElseThrow(() -> new IllegalArgumentException(String.format("Could not determine the type of the Optional parameter '%s' for instance factory '%s'", parameter.getName(), this.factory)));
                ConstructorMapper mapper2 = this.nestedMappers.computeIfAbsent(parameter, p -> new ConstructorMapper(JdbiConstructors.findFactoryFor(rawType), nestedPrefix));
                nestedMapper = mapper2.createSpecializedRowMapper(ctx, columnNames, columnNameMatchers, unmatchedColumns, Optional::ofNullable);
            } else {
                nestedMapper = this.nestedMappers.computeIfAbsent(parameter, p -> new ConstructorMapper(JdbiConstructors.findFactoryFor(p.getType()), nestedPrefix)).createSpecializedRowMapper(ctx, columnNames, columnNameMatchers, unmatchedColumns, Function.identity());
            }
            if (nestedMapper.isPresent()) {
                paramData.add(new ParameterData(i, parameter, nestedMapper.get()));
                matchedColumns = true;
                continue;
            }
            if (nullable) {
                paramData.add(new ParameterData(i, parameter, null));
                continue;
            }
            unmatchedParameters.add(ConstructorMapper.paramName(parameters, i, this.constructorProperties));
        }
        if (!matchedColumns) {
            return Optional.empty();
        }
        paramData.sort(Comparator.comparing(p -> p.propagateNull ? 1 : 0));
        if (!unmatchedParameters.isEmpty()) {
            throw new IllegalArgumentException(String.format(UNMATCHED_CONSTRUCTOR_PARAMETER, this.factory, unmatchedParameters));
        }
        BoundConstructorMapper<R> boundMapper = new BoundConstructorMapper<R>(paramData, postProcessor);
        OptionalInt propagateNullColumnIndex = this.locatePropagateNullColumnIndex(columnNames, columnNameMatchers);
        if (propagateNullColumnIndex.isPresent()) {
            return Optional.of(new NullDelegatingMapper<R>(propagateNullColumnIndex.getAsInt() + 1, boundMapper));
        }
        return Optional.of(boundMapper);
    }

    private OptionalInt locatePropagateNullColumnIndex(List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers) {
        Optional<String> propagateNullColumn = Optional.ofNullable(this.factory.getAnnotationIncludingType(PropagateNull.class)).map(PropagateNull::value).map(name -> ReflectionMapperUtil.addPropertyNamePrefix(this.prefix, name));
        if (!propagateNullColumn.isPresent()) {
            return OptionalInt.empty();
        }
        return ReflectionMapperUtil.findColumnIndex(propagateNullColumn.get(), columnNames, columnNameMatchers, propagateNullColumn::get);
    }

    private boolean isNullable(Parameter parameter) {
        return Stream.of(parameter.getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch("Nullable"::equals);
    }

    private static String paramName(Parameter[] parameters, int position, ConstructorProperties parameterNames) {
        Parameter parameter = parameters[position];
        return Optional.ofNullable(parameter.getAnnotation(ColumnName.class)).map(ColumnName::value).orElseGet(() -> {
            if (parameterNames != null) {
                return parameterNames.value()[position];
            }
            return parameter.getName();
        });
    }

    private String debugName(Parameter parameter) {
        return String.format("%s constructor parameter %s", this.factory.getDeclaringClass().getSimpleName(), parameter.getName());
    }

    static class UnmatchedConstructorMapper<T>
    implements RowMapper<T> {
        private final String message;

        UnmatchedConstructorMapper(String message) {
            this.message = message;
        }

        @Override
        public T map(ResultSet rs, StatementContext ctx) throws SQLException {
            throw new IllegalArgumentException(this.message);
        }
    }

    private static class ParameterData {
        final int index;
        final Parameter parameter;
        final RowMapper<?> mapper;
        final boolean propagateNull;
        final boolean isPrimitive;

        ParameterData(int index, Parameter parameter, RowMapper<?> mapper) {
            this.index = index;
            this.parameter = parameter;
            this.mapper = mapper;
            this.propagateNull = ParameterData.checkPropagateNullAnnotation(parameter);
            this.isPrimitive = parameter.getType().isPrimitive();
        }

        private static boolean checkPropagateNullAnnotation(Parameter parameter) {
            Optional<String> propagateNullValue = Optional.ofNullable(parameter.getAnnotation(PropagateNull.class)).map(PropagateNull::value);
            propagateNullValue.ifPresent(v -> {
                if (!v.isEmpty()) {
                    throw new IllegalArgumentException(String.format("@PropagateNull does not support a value (%s) on a parameter (%s)", v, parameter.getName()));
                }
            });
            return propagateNullValue.isPresent();
        }
    }

    class BoundConstructorMapper<R>
    implements RowMapper<R> {
        private final List<ParameterData> paramData;
        private final int count;
        private final Function<T, R> postProcessor;

        BoundConstructorMapper(List<ParameterData> paramData, Function<T, R> postProcessor) {
            this.paramData = paramData;
            this.count = ConstructorMapper.this.factory.getParameterCount();
            this.postProcessor = postProcessor;
        }

        @Override
        public R map(ResultSet rs, StatementContext ctx) throws SQLException {
            Object[] params = new Object[this.count];
            for (ParameterData p : this.paramData) {
                boolean wasNull;
                params[p.index] = p.mapper == null ? null : p.mapper.map(rs, ctx);
                boolean bl = wasNull = params[p.index] == null || p.isPrimitive && rs.wasNull();
                if (!p.propagateNull || !wasNull) continue;
                return this.postProcessor.apply(null);
            }
            return this.postProcessor.apply(ConstructorMapper.this.factory.newInstance(params));
        }

        public String toString() {
            return new StringJoiner(", ", BoundConstructorMapper.class.getSimpleName() + "[", "]").add("type=" + ConstructorMapper.this.factory.getDeclaringClass().getSimpleName()).add("prefix=" + ConstructorMapper.this.prefix).toString();
        }
    }
}

