/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper.reflect;

import bending.libraries.jdbi.v3.core.annotation.internal.JdbiAnnotations;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.Nested;
import bending.libraries.jdbi.v3.core.mapper.PropagateNull;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.mapper.RowMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.SingleColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.reflect.ColumnName;
import bending.libraries.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import bending.libraries.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import bending.libraries.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import bending.libraries.jdbi.v3.core.mapper.reflect.internal.NullDelegatingMapper;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import bending.libraries.jdbi.v3.core.qualifier.Qualifiers;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class FieldMapper<T>
implements RowMapper<T> {
    private static final String DEFAULT_PREFIX = "";
    private final Class<T> type;
    private final String prefix;
    private final Map<Field, FieldMapper<?>> nestedMappers = new ConcurrentHashMap();

    public static RowMapperFactory factory(Class<?> type) {
        return RowMapperFactory.of(type, FieldMapper.of(type));
    }

    public static RowMapperFactory factory(Class<?> type, String prefix) {
        return RowMapperFactory.of(type, FieldMapper.of(type, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return FieldMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new FieldMapper<T>(type, prefix);
    }

    private FieldMapper(Class<T> type, String prefix) {
        this.type = type;
        this.prefix = prefix;
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        UnaryOperator<String> caseChange = ctx.getConfig(ReflectionMappers.class).getCaseChange();
        List<String> columnNames = ReflectionMapperUtil.getColumnNames(rs, caseChange);
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> unmatchedColumns = new ArrayList<String>(columnNames);
        RowMapper mapper = this.createSpecializedRowMapper(ctx, columnNames, columnNameMatchers, unmatchedColumns, Function.identity()).orElseThrow(() -> new IllegalArgumentException(String.format("Mapping fields for type %s didn't find any matching columns in result set", this.type)));
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(unmatchedColumns, this.prefix, columnNameMatchers)) {
            throw new IllegalArgumentException(String.format("Mapping type %s could not match fields for columns: %s", this.type.getSimpleName(), unmatchedColumns));
        }
        return mapper;
    }

    private <R> Optional<RowMapper<R>> createSpecializedRowMapper(StatementContext ctx, List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers, List<String> unmatchedColumns, Function<T, R> postProcessor) {
        Constructor<T> constructor;
        ArrayList<FieldData> fields = new ArrayList<FieldData>();
        for (Class<T> aType = this.type; aType != null; aType = aType.getSuperclass()) {
            for (Field field : aType.getDeclaredFields()) {
                Optional<RowMapper<Object>> nestedMapper;
                Nested nested = field.getAnnotation(Nested.class);
                if (Modifier.isStatic(field.getModifiers()) || !JdbiAnnotations.isMapped(field)) continue;
                if (nested == null) {
                    String paramName = ReflectionMapperUtil.addPropertyNamePrefix(this.prefix, FieldMapper.paramName(field));
                    ReflectionMapperUtil.findColumnIndex(paramName, columnNames, columnNameMatchers, () -> this.debugName(field)).ifPresent(index -> {
                        QualifiedType<?> fieldType = QualifiedType.of(field.getGenericType()).withAnnotations(ctx.getConfig(Qualifiers.class).findFor(field));
                        ColumnMapper mapper = ctx.findColumnMapperFor(fieldType).orElse(ColumnMapper.getDefaultColumnMapper());
                        fields.add(new FieldData(field, new SingleColumnMapper(mapper, index + 1)));
                        unmatchedColumns.remove(columnNames.get(index));
                    });
                    continue;
                }
                String nestedPrefix = ReflectionMapperUtil.addPropertyNamePrefix(this.prefix, nested.value());
                if (!ReflectionMapperUtil.anyColumnsStartWithPrefix(columnNames, nestedPrefix, columnNameMatchers)) continue;
                if (field.getType().equals(Optional.class)) {
                    Class rawType = GenericTypes.findGenericParameter(field.getGenericType(), Optional.class).map(GenericTypes::getErasedType).orElseThrow(() -> new IllegalArgumentException(String.format("Could not determine the type of the Optional field %s", field.getName())));
                    nestedMapper = this.nestedMappers.computeIfAbsent(field, f -> new FieldMapper(rawType, nestedPrefix)).createSpecializedRowMapper(ctx, columnNames, columnNameMatchers, unmatchedColumns, Optional::ofNullable);
                } else {
                    nestedMapper = this.nestedMappers.computeIfAbsent(field, f -> new FieldMapper(field.getType(), nestedPrefix)).createSpecializedRowMapper(ctx, columnNames, columnNameMatchers, unmatchedColumns, Function.identity());
                }
                nestedMapper.ifPresent(mapper -> fields.add(new FieldData(field, (RowMapper<?>)mapper)));
            }
        }
        if (fields.isEmpty() && !columnNames.isEmpty()) {
            return Optional.empty();
        }
        fields.sort(Comparator.comparing(f -> f.propagateNull ? 1 : 0));
        ReflectionMappers reflectionConfig = ctx.getConfig(ReflectionMappers.class);
        fields.forEach(fieldData -> reflectionConfig.makeAccessible(fieldData.field));
        try {
            constructor = reflectionConfig.makeAccessible(this.type.getDeclaredConstructor(new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("A type, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        BoundFieldMapper<R> boundMapper = new BoundFieldMapper<R>(constructor, fields, postProcessor);
        OptionalInt propagateNullColumnIndex = this.locatePropagateNullColumnIndex(columnNames, columnNameMatchers);
        if (propagateNullColumnIndex.isPresent()) {
            return Optional.of(new NullDelegatingMapper<R>(propagateNullColumnIndex.getAsInt() + 1, boundMapper));
        }
        return Optional.of(boundMapper);
    }

    private OptionalInt locatePropagateNullColumnIndex(List<String> columnNames, List<ColumnNameMatcher> columnNameMatchers) {
        Optional<String> propagateNullColumn = Optional.ofNullable(this.type.getAnnotation(PropagateNull.class)).map(PropagateNull::value).map(name -> ReflectionMapperUtil.addPropertyNamePrefix(this.prefix, name));
        if (!propagateNullColumn.isPresent()) {
            return OptionalInt.empty();
        }
        return ReflectionMapperUtil.findColumnIndex(propagateNullColumn.get(), columnNames, columnNameMatchers, propagateNullColumn::get);
    }

    private static String paramName(Field field) {
        return Optional.ofNullable(field.getAnnotation(ColumnName.class)).map(ColumnName::value).orElseGet(field::getName);
    }

    private String debugName(Field field) {
        return String.format("%s.%s", this.type.getSimpleName(), field.getName());
    }

    public static boolean checkPropagateNullAnnotation(Field field) {
        Optional<String> propagateNullValue = Optional.ofNullable(field.getAnnotation(PropagateNull.class)).map(PropagateNull::value);
        propagateNullValue.ifPresent(v -> {
            if (!v.isEmpty()) {
                throw new IllegalArgumentException(String.format("@PropagateNull does not support a value (%s) on a field (%s)", v, field.getName()));
            }
        });
        return propagateNullValue.isPresent();
    }

    class BoundFieldMapper<R>
    implements RowMapper<R> {
        private final Constructor<T> constructor;
        private final List<FieldData> fields;
        private final Function<T, R> postProcessor;

        BoundFieldMapper(Constructor<T> constructor, List<FieldData> fields, Function<T, R> postProcessor) {
            this.constructor = constructor;
            this.fields = fields;
            this.postProcessor = postProcessor;
        }

        @Override
        public R map(ResultSet rs, StatementContext ctx) throws SQLException {
            Object obj = this.construct();
            for (FieldData f : this.fields) {
                boolean wasNull;
                Object value = f.mapper.map(rs, ctx);
                boolean bl = wasNull = value == null || f.isPrimitive && rs.wasNull();
                if (f.propagateNull && wasNull) {
                    return this.postProcessor.apply(null);
                }
                this.writeField(obj, f.field, value);
            }
            return this.postProcessor.apply(obj);
        }

        private T construct() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                throw new IllegalArgumentException(String.format("A type, %s, was mapped which was not instantiable", FieldMapper.this.type.getName()), e);
            }
        }

        private void writeField(T obj, Field field, Object value) {
            try {
                field.set(obj, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access property, %s", field.getName()), e);
            }
        }

        public String toString() {
            return new StringJoiner(", ", BoundFieldMapper.class.getSimpleName() + "[", "]").add("type=" + FieldMapper.this.type.getSimpleName()).add("prefix=" + FieldMapper.this.prefix).toString();
        }
    }

    private static class FieldData {
        final Field field;
        final RowMapper<?> mapper;
        final boolean propagateNull;
        final boolean isPrimitive;

        FieldData(Field field, RowMapper<?> mapper) {
            this.field = field;
            this.mapper = mapper;
            this.propagateNull = FieldMapper.checkPropagateNullAnnotation(field);
            this.isPrimitive = field.getType().isPrimitive();
        }
    }
}

