/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper.reflect.internal;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringJoiner;

public final class NullDelegatingMapper<T>
implements RowMapper<T> {
    private final int index;
    private final RowMapper<T> delegate;

    public NullDelegatingMapper(int index, RowMapper<T> delegate) {
        this.index = index;
        this.delegate = delegate;
    }

    @Override
    public void init(ConfigRegistry registry) {
        this.delegate.init(registry);
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        rs.getObject(this.index);
        if (rs.wasNull()) {
            return null;
        }
        return this.delegate.map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        RowMapper<T> newDelegate = this.delegate.specialize(rs, ctx);
        if (newDelegate instanceof NullDelegatingMapper) {
            return newDelegate;
        }
        return new NullDelegatingMapper<T>(this.index, newDelegate);
    }

    public String toString() {
        return new StringJoiner(", ", NullDelegatingMapper.class.getSimpleName() + "[", "]").add("index=" + this.index).add("delegate=" + String.valueOf(this.delegate)).toString();
    }
}

