/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper.reflect.internal;

import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.internal.UtilityClassException;
import bending.libraries.jdbi.v3.core.mapper.reflect.ColumnName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class PojoBuilderUtils {
    private static final String[] GETTER_PREFIXES = new String[]{"get", "is"};

    private PojoBuilderUtils() {
        throw new UtilityClassException();
    }

    public static boolean isProperty(Method m) {
        return m.getParameterCount() == 0 && !m.isSynthetic() && !Modifier.isStatic(m.getModifiers()) && m.getDeclaringClass() != Object.class;
    }

    public static String propertyName(Method m) {
        return Optional.ofNullable(m.getAnnotation(ColumnName.class)).map(ColumnName::value).orElseGet(() -> PojoBuilderUtils.defaultSetterName(m.getName()));
    }

    public static String defaultSetterName(String name) {
        for (String prefix : GETTER_PREFIXES) {
            if (!name.startsWith(prefix) || name.length() <= prefix.length() || !Character.isUpperCase(name.charAt(prefix.length()))) continue;
            return PojoBuilderUtils.chopPrefix(name, prefix.length());
        }
        return name;
    }

    public static String chopPrefix(String name, int off) {
        return name.substring(off, off + 1).toLowerCase(Locale.ROOT) + name.substring(off + 1);
    }

    private static Set<String> setterNames(String name) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String rest = name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
        names.add("set" + rest);
        names.add("is" + rest);
        return names;
    }

    public static MethodHandle findBuilderSetter(Class<?> builderClass, String name, Method decl, Type type) throws IllegalAccessException {
        ArrayList<NoSuchMethodException> failures = new ArrayList<NoSuchMethodException>();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(PojoBuilderUtils.defaultSetterName(decl.getName()));
        names.add(name);
        if (name.length() > 1) {
            names.addAll(PojoBuilderUtils.setterNames(name));
        }
        Optional<String> columnName = Optional.ofNullable(decl.getAnnotation(ColumnName.class)).map(ColumnName::value);
        columnName.ifPresent(n -> {
            if (n.equals(name)) {
                names.addAll(PojoBuilderUtils.setterNames(PojoBuilderUtils.defaultSetterName(decl.getName())));
            }
        });
        for (String tryName : names) {
            try {
                return MethodHandles.lookup().unreflect(builderClass.getMethod(tryName, GenericTypes.getErasedType(type)));
            }
            catch (NoSuchMethodException e) {
                failures.add(e);
            }
        }
        for (Method m : builderClass.getMethods()) {
            if (!names.contains(m.getName()) || m.getParameterCount() != 1) continue;
            return MethodHandles.lookup().unreflect(m);
        }
        IllegalArgumentException iae = new IllegalArgumentException("Failed to find builder setter for property " + name + " on " + String.valueOf(builderClass));
        failures.forEach(iae::addSuppressed);
        return MethodHandles.dropArguments(MethodHandles.throwException(Object.class, IllegalArgumentException.class), 1, Arrays.asList(Object.class, Object.class)).bindTo(iae);
    }

    public static MethodHandle alwaysSet() {
        return MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, true), 0, new Class[]{Object.class});
    }
}

