/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.mapper.reflect.internal;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.config.JdbiConfig;
import bending.libraries.jdbi.v3.core.generic.GenericTypes;
import bending.libraries.jdbi.v3.core.internal.CopyOnWriteHashMap;
import bending.libraries.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import bending.libraries.jdbi.v3.core.mapper.reflect.internal.PojoPropertiesFactory;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;

public class PojoTypes
implements JdbiConfig<PojoTypes> {
    private final Map<Class<?>, PojoPropertiesFactory> factories;
    private ConfigRegistry registry;

    public PojoTypes() {
        this.factories = new CopyOnWriteHashMap();
    }

    private PojoTypes(PojoTypes other) {
        this.factories = new CopyOnWriteHashMap(other.factories);
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public PojoTypes register(Class<?> key, PojoPropertiesFactory factory) {
        this.factories.put(key, factory);
        return this;
    }

    public Optional<PojoProperties<?>> findFor(Type type) {
        return Optional.ofNullable(this.factories.get(GenericTypes.getErasedType(type))).map(ppf -> ppf.create(type, this.registry));
    }

    @Override
    public PojoTypes createCopy() {
        return new PojoTypes(this);
    }
}

