/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.result;

import bending.libraries.jdbi.v3.core.result.ResultIterable;
import bending.libraries.jdbi.v3.core.result.ResultIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public interface BatchResultIterable<T>
extends ResultIterable<T> {
    public List<List<T>> listPerBatch();

    public static <U> BatchResultIterable<U> of(final ResultIterable<U> delegate, final Supplier<int[]> modifiedRowCountsSupplier) {
        return new BatchResultIterable<U>(){

            @Override
            public List<List<U>> listPerBatch() {
                ArrayList results = new ArrayList();
                try (Iterator iterator = delegate.iterator();){
                    for (int modCount : (int[])modifiedRowCountsSupplier.get()) {
                        if (modCount <= 0) {
                            results.add(Collections.emptyList());
                            continue;
                        }
                        ArrayList batchResult = new ArrayList(modCount);
                        for (int i = 0; i < modCount; ++i) {
                            batchResult.add(iterator.next());
                        }
                        results.add(batchResult);
                    }
                }
                return results;
            }

            @Override
            public ResultIterator<U> iterator() {
                return delegate.iterator();
            }
        };
    }
}

