/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.result;

import bending.libraries.jdbi.v3.core.collector.ElementTypeNotFoundException;
import bending.libraries.jdbi.v3.core.collector.NoSuchCollectorException;
import bending.libraries.jdbi.v3.core.generic.GenericType;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.GenericMapMapperFactory;
import bending.libraries.jdbi.v3.core.mapper.MapMapper;
import bending.libraries.jdbi.v3.core.mapper.NoSuchMapperException;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.mapper.RowViewMapper;
import bending.libraries.jdbi.v3.core.mapper.SingleColumnMapper;
import bending.libraries.jdbi.v3.core.mapper.reflect.BeanMapper;
import bending.libraries.jdbi.v3.core.qualifier.QualifiedType;
import bending.libraries.jdbi.v3.core.result.ResultIterable;
import bending.libraries.jdbi.v3.core.result.ResultSetAccumulator;
import bending.libraries.jdbi.v3.core.result.ResultSetException;
import bending.libraries.jdbi.v3.core.result.ResultSetScanner;
import bending.libraries.jdbi.v3.core.result.RowReducer;
import bending.libraries.jdbi.v3.core.result.RowView;
import bending.libraries.jdbi.v3.core.result.UnableToProduceResultException;
import bending.libraries.jdbi.v3.core.result.internal.RowViewImpl;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public interface ResultBearing {
    public static ResultBearing of(final Supplier<ResultSet> resultSetSupplier, final StatementContext ctx) {
        return new ResultBearing(){

            @Override
            public <R> R scanResultSet(ResultSetScanner<R> resultSetScanner) {
                try {
                    return resultSetScanner.scanResultSet(resultSetSupplier, ctx);
                }
                catch (SQLException e) {
                    throw new ResultSetException("Error reading result set", e, ctx);
                }
            }
        };
    }

    public <R> R scanResultSet(ResultSetScanner<R> var1);

    default public <T> ResultIterable<T> mapTo(Class<T> type) {
        return this.mapTo(QualifiedType.of(type));
    }

    default public <T> ResultIterable<T> mapTo(GenericType<T> type) {
        return this.mapTo(QualifiedType.of(type));
    }

    default public ResultIterable<?> mapTo(Type type) {
        return this.mapTo(QualifiedType.of(type));
    }

    default public <T> ResultIterable<T> mapTo(QualifiedType<T> type) {
        return this.scanResultSet((resultSetSupplier, ctx) -> {
            RowMapper rowMapper = ctx.findMapperFor(type).orElseThrow(() -> new NoSuchMapperException("No mapper registered for type " + String.valueOf(type)));
            return ResultIterable.of(resultSetSupplier, rowMapper, ctx);
        });
    }

    default public <T> ResultIterable<T> mapToBean(Class<T> type) {
        return this.map(BeanMapper.of(type));
    }

    default public ResultIterable<Map<String, Object>> mapToMap() {
        return this.map(new MapMapper());
    }

    default public <T> ResultIterable<Map<String, T>> mapToMap(Class<T> valueType) {
        return this.scanResultSet((resultSetSupplier, ctx) -> ResultIterable.of(resultSetSupplier, GenericMapMapperFactory.getMapperForValueType(valueType, ctx.getConfig()), ctx));
    }

    default public <T> ResultIterable<Map<String, T>> mapToMap(GenericType<T> valueType) {
        return this.scanResultSet((resultSetSupplier, ctx) -> ResultIterable.of(resultSetSupplier, GenericMapMapperFactory.getMapperForValueType(valueType, ctx.getConfig()), ctx));
    }

    default public <T> ResultIterable<T> map(ColumnMapper<T> mapper) {
        return this.map(new SingleColumnMapper<T>(mapper));
    }

    default public <T> ResultIterable<T> map(RowMapper<T> mapper) {
        return this.scanResultSet((resultSetSupplier, ctx) -> ResultIterable.of(resultSetSupplier, mapper, ctx));
    }

    default public <T> ResultIterable<T> map(RowViewMapper<T> mapper) {
        return this.map((RowMapper<T>)mapper);
    }

    default public <C, R> Stream<R> reduceRows(RowReducer<C, R> rowReducer) {
        return this.scanResultSet((resultSetSupplier, context) -> {
            StatementContext ctx = context;
            try {
                ResultSet resultSet = (ResultSet)resultSetSupplier.get();
                RowViewImpl rowView = new RowViewImpl(resultSet, ctx);
                Object container = rowReducer.container();
                while (resultSet.next()) {
                    rowReducer.accumulate(container, rowView);
                }
                Stream stream = (Stream)rowReducer.stream(container).onClose(ctx::close);
                if (ctx != null) {
                    ctx.close();
                }
                return stream;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new UnableToProduceResultException(e, context);
                }
            }
        });
    }

    default public <K, V> Stream<V> reduceRows(BiConsumer<Map<K, V>, RowView> accumulator) {
        return this.reduceRows(accumulator::accept);
    }

    default public <U> U reduceRows(U seed, BiFunction<U, RowView, U> accumulator) {
        return (U)this.scanResultSet((resultSetSupplier, context) -> {
            StatementContext ctx = context;
            try {
                ResultSet resultSet = (ResultSet)resultSetSupplier.get();
                RowViewImpl rowView = new RowViewImpl(resultSet, ctx);
                Object result = seed;
                while (resultSet.next()) {
                    result = accumulator.apply(result, rowView);
                }
                Object object = result;
                if (ctx != null) {
                    ctx.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new UnableToProduceResultException(e, context);
                }
            }
        });
    }

    default public <U> U reduceResultSet(U seed, ResultSetAccumulator<U> accumulator) {
        return (U)this.scanResultSet((resultSetSupplier, context) -> {
            StatementContext ctx = context;
            try {
                ResultSet resultSet = (ResultSet)resultSetSupplier.get();
                Object result = seed;
                while (resultSet.next()) {
                    result = accumulator.apply(result, resultSet, ctx);
                }
                Object object = result;
                if (ctx != null) {
                    ctx.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new UnableToProduceResultException(e, context);
                }
            }
        });
    }

    default public <A, R> R collectRows(Collector<RowView, A, R> collector) {
        return (R)this.scanResultSet((resultSetSupplier, context) -> {
            StatementContext ctx = context;
            try {
                ResultSet resultSet = (ResultSet)resultSetSupplier.get();
                RowViewImpl rowView = new RowViewImpl(resultSet, ctx);
                Object accumulator = collector.supplier().get();
                BiConsumer consumer = collector.accumulator();
                while (resultSet.next()) {
                    consumer.accept(accumulator, rowView);
                }
                Object r = collector.finisher().apply(accumulator);
                if (ctx != null) {
                    ctx.close();
                }
                return r;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new UnableToProduceResultException(e, context);
                }
            }
        });
    }

    default public <R> R collectInto(Class<R> containerType) {
        return (R)this.collectInto((Type)containerType);
    }

    default public <R> R collectInto(GenericType<R> containerType) {
        return (R)this.collectInto(containerType.getType());
    }

    default public Object collectInto(Type containerType) {
        return this.scanResultSet((resultSetSupplier, ctx) -> {
            Collector<?, ?, ?> collector = ctx.findCollectorFor(containerType).orElseThrow(() -> new NoSuchCollectorException("No collector registered for container type " + String.valueOf(containerType)));
            Type elementType = ctx.findElementTypeFor(containerType).orElseThrow(() -> new ElementTypeNotFoundException("Unknown element type for container type " + String.valueOf(containerType)));
            RowMapper<?> rowMapper = ctx.findMapperFor(elementType).orElseThrow(() -> new NoSuchMapperException("No mapper registered for element type " + String.valueOf(elementType)));
            return ResultIterable.of(resultSetSupplier, rowMapper, ctx).collect(collector);
        });
    }
}

