/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.result;

import bending.libraries.jdbi.v3.core.generic.GenericType;
import bending.libraries.jdbi.v3.core.mapper.RowMapper;
import bending.libraries.jdbi.v3.core.result.IteratorCallback;
import bending.libraries.jdbi.v3.core.result.IteratorConsumer;
import bending.libraries.jdbi.v3.core.result.ResultIterator;
import bending.libraries.jdbi.v3.core.result.StreamCallback;
import bending.libraries.jdbi.v3.core.result.StreamConsumer;
import bending.libraries.jdbi.v3.core.result.internal.ResultSetResultIterable;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import bending.libraries.jdbi.v3.meta.Alpha;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@FunctionalInterface
public interface ResultIterable<T>
extends Iterable<T> {
    public static <T> ResultIterable<T> of(Supplier<ResultSet> resultSetSupplier, RowMapper<T> mapper, StatementContext ctx) {
        return new ResultSetResultIterable<T>(mapper, ctx, resultSetSupplier);
    }

    public static <T> ResultIterable<T> of(ResultIterator<T> iterator) {
        return () -> iterator;
    }

    @Override
    public ResultIterator<T> iterator();

    default public <X extends Exception> void useIterator(IteratorConsumer<T, X> consumer) throws X {
        this.withIterator(iterator -> {
            consumer.useIterator(iterator);
            return null;
        });
    }

    default public <R, X extends Exception> R withIterator(IteratorCallback<T, R, X> callback) throws X {
        try (Iterator iterator = this.iterator();){
            R r = callback.withIterator((ResultIterator<T>)iterator);
            return r;
        }
    }

    default public <R> ResultIterable<R> map(final Function<? super T, ? extends R> mapper) {
        return () -> new ResultIteratorDelegate<T, R>((ResultIterator)this.iterator()){

            @Override
            public R next() {
                return mapper.apply(this.getDelegate().next());
            }
        };
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        this.forEachWithCount(action);
    }

    default public int forEachWithCount(Consumer<? super T> action) {
        Objects.requireNonNull(action, "Action required");
        try (Iterator iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                action.accept(iter.next());
            }
            int n = count;
            return n;
        }
    }

    default public T one() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found none");
            }
            Object r = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found multiple");
            }
            Object e = r;
            return (T)e;
        }
    }

    default public Optional<T> findOne() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Object r = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected zero to one elements, but found multiple");
            }
            Optional optional = Optional.ofNullable(r);
            return optional;
        }
    }

    @Deprecated(since="3.8.0", forRemoval=true)
    default public T findOnly() {
        return this.one();
    }

    default public T first() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected at least one element, but found none");
            }
            Object e = iter.next();
            return (T)e;
        }
    }

    default public Optional<T> findFirst() {
        try (Iterator iter = this.iterator();){
            Optional optional = iter.hasNext() ? Optional.ofNullable(iter.next()) : Optional.empty();
            return optional;
        }
    }

    default public Stream<T> stream() {
        Iterator iterator = this.iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).onClose(((ResultIterator)iterator)::close);
    }

    default public <X extends Exception> void useStream(StreamConsumer<T, X> consumer) throws X {
        this.withStream(stream -> {
            consumer.useStream(stream);
            return null;
        });
    }

    default public <R, X extends Exception> R withStream(StreamCallback<T, R, X> callback) throws X {
        try (Stream<T> stream = this.stream();){
            R r = callback.withStream(stream);
            return r;
        }
    }

    default public List<T> list() {
        return this.collect(Collectors.toList());
    }

    default public Set<T> set() {
        return this.collect(Collectors.toSet());
    }

    default public <R> R collect(Collector<? super T, ?, R> collector) {
        try (Stream<? super T> stream = this.stream();){
            R r = stream.collect(collector);
            return r;
        }
    }

    default public <K, V> Map<K, V> collectToMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return this.collect(Collectors.toMap(keyFunction, valueFunction));
    }

    @Alpha
    default public <C extends Collection<T>> C toCollection(Supplier<C> supplier) {
        return (C)((Collection)this.collect(Collectors.toCollection(supplier)));
    }

    @Alpha
    default public <R> R collectInto(Type containerType) {
        throw new UnsupportedOperationException();
    }

    @Alpha
    default public <R> R collectInto(GenericType<R> containerType) {
        return this.collectInto(containerType.getType());
    }

    @Alpha
    default public List<T> collectIntoList() {
        return this.list();
    }

    @Alpha
    default public Set<T> collectIntoSet() {
        return this.set();
    }

    default public <U> U reduce(U identity, BiFunction<U, T, U> accumulator) {
        try (Stream<T> stream = this.stream();){
            U u2 = stream.reduce(identity, accumulator, (u, v) -> {
                throw new UnsupportedOperationException("parallel operation not supported");
            });
            return u2;
        }
    }

    default public ResultIterable<T> filter(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "Filter required");
        return () -> new ResultIteratorDelegate<T, T>((ResultIterator)this.iterator()){
            private T next;

            @Override
            public boolean hasNext() {
                return this.next != null || this.findNext();
            }

            @Override
            public T next() {
                if (this.next == null && !this.findNext()) {
                    throw new NoSuchElementException("No more filtered results");
                }
                Object n = this.next;
                this.next = null;
                return n;
            }

            private boolean findNext() {
                this.next = null;
                while (this.getDelegate().hasNext()) {
                    Object n = this.getDelegate().next();
                    if (!predicate.test(n)) continue;
                    this.next = n;
                    return true;
                }
                return false;
            }
        };
    }

    public static abstract class ResultIteratorDelegate<T, R>
    implements ResultIterator<R> {
        private final ResultIterator<T> delegate;

        ResultIteratorDelegate(ResultIterator<T> del) {
            this.delegate = Objects.requireNonNull(del, "Delegate required");
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public final void close() {
            this.delegate.close();
        }

        @Override
        public final StatementContext getContext() {
            return this.delegate.getContext();
        }

        protected final ResultIterator<T> getDelegate() {
            return this.delegate;
        }
    }
}

