/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.result.internal;

import bending.libraries.jdbi.v3.core.statement.Cleanable;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;

public abstract class ResultSetSupplier
implements Supplier<ResultSet>,
Cleanable {
    private final Supplier<ResultSet> supplier;
    protected Cleanable cleanable = NO_OP;

    public static ResultSetSupplier closingContext(Supplier<ResultSet> supplier, final StatementContext context) {
        return new ResultSetSupplier(supplier){

            @Override
            public void close() throws SQLException {
                try (StatementContext statementContext = context;){
                    this.cleanable.close();
                }
            }
        };
    }

    public static ResultSetSupplier notClosingContext(Supplier<ResultSet> supplier) {
        return new ResultSetSupplier((Supplier)supplier){

            @Override
            public void close() throws SQLException {
                this.cleanable.close();
            }
        };
    }

    private ResultSetSupplier(Supplier<ResultSet> supplier) {
        this.supplier = supplier;
    }

    @Override
    public ResultSet get() {
        ResultSet resultSet = this.supplier.get();
        if (resultSet != null) {
            this.cleanable = resultSet::close;
        }
        return resultSet;
    }
}

