/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.Handle;
import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.internal.exceptions.Sneaky;
import bending.libraries.jdbi.v3.core.result.ResultBearing;
import bending.libraries.jdbi.v3.core.result.internal.ResultSetSupplier;
import bending.libraries.jdbi.v3.core.statement.CallableStatementMapper;
import bending.libraries.jdbi.v3.core.statement.OutParameters;
import bending.libraries.jdbi.v3.core.statement.SqlStatement;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import bending.libraries.jdbi.v3.core.statement.StatementCustomizers;
import bending.libraries.jdbi.v3.core.statement.UnableToExecuteStatementException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Call
extends SqlStatement<Call> {
    private final List<OutParamArgument> outParamArguments = new ArrayList<OutParamArgument>();

    public Call(Handle handle, CharSequence sql) {
        super(handle, sql);
    }

    public Call(Handle handle, String sql) {
        super(handle, sql);
    }

    @Override
    PreparedStatement createStatement(String parsedSql) throws SQLException {
        return this.getHandle().getStatementBuilder().createCall(this.getHandle().getConnection(), parsedSql, this.getContext());
    }

    public Call registerOutParameter(int position, int sqlType) {
        return this.registerOutParameter(position, sqlType, null);
    }

    public Call registerOutParameter(int position, int sqlType, CallableStatementMapper mapper) {
        this.getBinding().addPositional(position, new OutParamArgument(sqlType, mapper, null));
        return this;
    }

    public Call registerOutParameter(String name, int sqlType) {
        return this.registerOutParameter(name, sqlType, null);
    }

    public Call registerOutParameter(String name, int sqlType, CallableStatementMapper mapper) {
        this.getBinding().addNamed(name, new OutParamArgument(sqlType, mapper, name));
        return this;
    }

    public OutParameters invoke() {
        return (OutParameters)this.invoke(Function.identity());
    }

    public void invoke(Consumer<OutParameters> resultConsumer) {
        this.invoke((OutParameters r) -> {
            resultConsumer.accept((OutParameters)r);
            return null;
        });
    }

    public <T> T invoke(Function<OutParameters, T> resultComputer) {
        this.internalExecute();
        Supplier<ResultSet> resultSetSupplier = () -> {
            try {
                return this.stmt.getResultSet();
            }
            catch (SQLException e) {
                throw Sneaky.throwAnyway(e);
            }
        };
        ResultBearing resultSet = ResultBearing.of(ResultSetSupplier.notClosingContext(resultSetSupplier), this.getContext());
        OutParameters out = new OutParameters(resultSet, this.getContext());
        this.outParamArguments.forEach(outparamArgument -> {
            Supplier<Object> supplier = outparamArgument.supplier((CallableStatement)this.stmt);
            out.putValueSupplier(outparamArgument.position - 1, outparamArgument.name, supplier);
        });
        return resultComputer.apply(out);
    }

    public Call setFetchSize(int fetchSize) {
        return (Call)this.addCustomizer(StatementCustomizers.fetchSize(fetchSize));
    }

    public Call setMaxRows(int maxRows) {
        return (Call)this.addCustomizer(StatementCustomizers.maxRows(maxRows));
    }

    public Call setMaxFieldSize(int maxFields) {
        return (Call)this.addCustomizer(StatementCustomizers.maxFieldSize(maxFields));
    }

    public Call concurrentUpdatable() {
        this.getContext().setConcurrentUpdatable(true);
        return this;
    }

    private class OutParamArgument
    implements Argument {
        private final int sqlType;
        private final CallableStatementMapper mapper;
        private final String name;
        private int position;

        OutParamArgument(int sqlType, CallableStatementMapper mapper, String name) {
            this.sqlType = sqlType;
            this.mapper = mapper;
            this.name = name;
            Call.this.outParamArguments.add(this);
        }

        @Override
        public void apply(int outPosition, PreparedStatement statement, StatementContext ctx) throws SQLException {
            ((CallableStatement)statement).registerOutParameter(outPosition, this.sqlType);
            this.position = outPosition;
        }

        public Supplier<Object> supplier(CallableStatement stmt) {
            return () -> {
                Object value = this.map(stmt);
                return this.isNull(stmt) ? null : value;
            };
        }

        private Object map(CallableStatement stmt) {
            try {
                if (this.mapper != null) {
                    return this.mapper.map(this.position, stmt);
                }
                switch (this.sqlType) {
                    case -16: 
                    case -9: 
                    case -1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return stmt.getString(this.position);
                    }
                    case -3: 
                    case 2004: {
                        return stmt.getBytes(this.position);
                    }
                    case 5: {
                        return stmt.getShort(this.position);
                    }
                    case 4: {
                        return stmt.getInt(this.position);
                    }
                    case -5: {
                        return stmt.getLong(this.position);
                    }
                    case 92: 
                    case 93: {
                        return stmt.getTimestamp(this.position);
                    }
                    case 91: {
                        return stmt.getDate(this.position);
                    }
                    case 6: {
                        return Float.valueOf(stmt.getFloat(this.position));
                    }
                    case 3: 
                    case 8: {
                        return stmt.getDouble(this.position);
                    }
                }
                return stmt.getObject(this.position);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Could not get OUT parameter from statement", e, Call.this.getContext());
            }
        }

        private boolean isNull(CallableStatement stmt) {
            try {
                return stmt.wasNull();
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Could not get OUT parameter from statement", e, Call.this.getContext());
            }
        }
    }
}

