/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.inlined.org.antlr.v4.runtime.$CharStreams;
import bending.libraries.jdbi.v3.core.inlined.org.antlr.v4.runtime.$Token;
import bending.libraries.jdbi.v3.core.internal.lexer.DefineStatementLexer;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import bending.libraries.jdbi.v3.core.statement.TemplateEngine;
import bending.libraries.jdbi.v3.core.statement.UnableToCreateStatementException;
import bending.libraries.jdbi.v3.core.statement.internal.ErrorListener;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class DefinedAttributeTemplateEngine
implements TemplateEngine.Parsing {
    @Override
    public Optional<Function<StatementContext, String>> parse(String template, ConfigRegistry config) {
        StringBuilder buf = new StringBuilder();
        ArrayList<BiConsumer<StatementContext, StringBuilder>> preparation = new ArrayList<BiConsumer<StatementContext, StringBuilder>>();
        Runnable pushBuf = () -> {
            if (buf.length() > 0) {
                String bit = buf.toString();
                buf.setLength(0);
                preparation.add((ctx, b) -> b.append(bit));
            }
        };
        DefineStatementLexer lexer = new DefineStatementLexer($CharStreams.fromString(template));
        lexer.addErrorListener(new ErrorListener());
        $Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    buf.append(t.getText());
                    break;
                }
                case 5: {
                    pushBuf.run();
                    String text = t.getText();
                    String key = text.substring(1, text.length() - 1);
                    preparation.add((ctx, b) -> {
                        Object value = ctx.getAttribute(key);
                        if (value == null) {
                            throw new UnableToCreateStatementException("Undefined attribute for token '" + text + "'", (StatementContext)ctx);
                        }
                        b.append(value);
                    });
                    break;
                }
                case 4: {
                    buf.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        pushBuf.run();
        return Optional.of(ctx -> {
            try {
                StringBuilder result = new StringBuilder();
                preparation.forEach(a -> a.accept(ctx, result));
                return result.toString();
            }
            catch (RuntimeException e) {
                throw new UnableToCreateStatementException("Error rendering SQL template: '" + template + "'", e, (StatementContext)ctx);
            }
        });
    }
}

