/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.jdbi.v3.core.statement;

import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.config.internal.ConfigCache;
import bending.libraries.jdbi.v3.core.config.internal.ConfigCaches;
import bending.libraries.jdbi.v3.core.internal.JdbiClassUtils;
import bending.libraries.jdbi.v3.core.statement.ArgumentBinder;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

class DescribedArgument
implements Argument {
    private static final ConfigCache<Class<?>, Boolean> ARG_CLASS_HAS_TOSTRING = ConfigCaches.declare(type -> JdbiClassUtils.safeMethodLookup(type, "toString", new Class[0]).map(Method::getDeclaringClass).map(c -> c != Object.class).orElse(false));
    private final Argument arg;
    private final String description;

    DescribedArgument(Argument arg, Object value) {
        this.arg = arg;
        this.description = Objects.toString(ArgumentBinder.unwrap(value));
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        this.arg.apply(position, statement, ctx);
    }

    public String toString() {
        return this.description;
    }

    public static Argument wrap(StatementContext ctx, Argument arg, Object value) {
        if (Boolean.TRUE.equals(ARG_CLASS_HAS_TOSTRING.get(arg.getClass(), ctx))) {
            return arg;
        }
        return new DescribedArgument(arg, value);
    }
}

